// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
 //$Revision: 1.8 $
#include "hk_kdedatabasesetting.h"
#include <klocale.h>
#include <kapplication.h>
#include <kaction.h>
#include <kiconloader.h>
#include <kstandarddirs.h>
#include <klistview.h>
#include <kcombobox.h>
#include <kpushbutton.h>

#include <qframe.h>
#include <qpixmap.h>
#include <qstringlist.h>
#include <qheader.h>
#include <qlabel.h>
#include <qwidgetstack.h>
#include <kapplication.h>
#include <kconfig.h>

#include <hk_class.h>
#include <hk_database.h>
#include <hk_connection.h>


hk_kdedatabasesetting::hk_kdedatabasesetting( hk_database*db, QWidget* parent,  const char* name, bool modal, WFlags fl )
    : hk_kdedatabasesettingbase( parent, name, modal, fl )
{
 p_database=db;
 QStringList list;
 list.append(i18n("Local"));
 list.append(i18n("Central"));
 queryload->insertStringList(list);
 querystore->insertStringList(list);

 formload->insertStringList(list);
 formstore->insertStringList(list);

 reportload->insertStringList(list);
 reportstore->insertStringList(list);

 list.prepend("");
 allload->insertStringList(list);
 allstore->insertStringList(list);
   
  KIconLoader* loader=KGlobal::iconLoader();
  loader->addAppDir("hk_kdeclasses");

  p_systemtableitem= new KListViewItem(listview,i18n("Load/Save"));
  p_systemtableitem->setPixmap(0,loader->loadIcon("filesave",KIcon::Desktop));
  p_systemtableitem->setMultiLinesEnabled(true);
  
  if (p_database && p_database->connection()->server_needs(hk_connection::NEEDS_MANUAL_CHARSET))
  {
    p_localeitem=new KListViewItem(listview,i18n("Regional"));
    p_localeitem->setPixmap(0,loader->loadIcon("locale",KIcon::Desktop));
    p_localeitem->setMultiLinesEnabled(true);
    for (unsigned int i=0;i<sizeof(charsets)/sizeof(hk_string);++i)
     {
      databaseencodingfield->insertItem(QString::fromUtf8(l2u(charsets[i]).c_str()));
     }
   databaseencodingfield->setCurrentText(QString::fromUtf8(l2u(p_database->databasecharset()).c_str()));
  }
  else 
  p_localeitem=NULL;
  listview->header()->setLabel( 0, "",listview->width() );
  listview->setCurrentItem(p_systemtableitem);
  p_systemtableitem->setSelected(true);
  if (!p_database) return;
  

  queryload->setCurrentItem(p_database->loadmode(ft_query)==hk_database::central?1:0);
  querystore->setCurrentItem(p_database->storagemode(ft_query)==hk_database::central?1:0);
  
  formload->setCurrentItem(p_database->loadmode(ft_form)==hk_database::central?1:0);
  formstore->setCurrentItem(p_database->storagemode(ft_form)==hk_database::central?1:0);
  
  reportload->setCurrentItem(p_database->loadmode(ft_report)==hk_database::central?1:0);
  reportstore->setCurrentItem(p_database->storagemode(ft_report)==hk_database::central?1:0);
  
  automaticupdatefield->setCurrentItem(p_database->default_automatic_data_update()?0:1);
  selection_changed();
  ok_button->setEnabled(false);
 KConfig* c=kapp->config();
  QRect rect(0,0,500,300);
  c->setGroup("Databasesetting");
  QRect g;
  g=c->readRectEntry("Geometry",&rect);
  setGeometry(g);
}

hk_kdedatabasesetting::~hk_kdedatabasesetting()
{
}


void hk_kdedatabasesetting::create_clicked()
{
  if (!p_database->create_centralstoragetable())
    {
      hk_class::show_warningmessage(hk_class::hk_translate("Error: could not create central storage table\n Check your permissions"));
      return;
    }
  selection_changed();
}

void hk_kdedatabasesetting::selection_changed()
{
bool hasstorage=p_database->has_centralstoragetable();
createbutton->setEnabled(!hasstorage && p_database&&p_database->connection()->server_supports(hk_connection::SUPPORTS_NEW_TABLE)
);
storageframe->setEnabled(hasstorage);
ok_button->setEnabled(true);
}

void hk_kdedatabasesetting::alload_changed()
{
if (allload->currentItem()==0) return;
int p=allload->currentItem()-1;
queryload->setCurrentItem(p);
formload->setCurrentItem(p);
reportload->setCurrentItem(p);
ok_button->setEnabled(true);
}

void hk_kdedatabasesetting::allstore_changed()
{
if (allstore->currentItem()==0) return;
int p=allstore->currentItem()-1;
querystore->setCurrentItem(p);
formstore->setCurrentItem(p);
reportstore->setCurrentItem(p);
ok_button->setEnabled(true);

}



void hk_kdedatabasesetting::listview_changed()
{
  widgetstack->raiseWidget(listview->currentItem()==p_localeitem?1:0);
      headertext->setText( listview->currentItem()==p_localeitem?tr("Regional"):tr( "Open and store files:" ) );

}

void hk_kdedatabasesetting::ok_clicked()
{
 p_database->set_storagemode(ft_query, ((queryload->currentItem()==1)?hk_database::central:hk_database::local),
                                  ((querystore->currentItem()==1)?hk_database::central:hk_database::local));
 p_database->set_storagemode(ft_form, ((formload->currentItem()==1)?hk_database::central:hk_database::local),
                                  ((formstore->currentItem()==1)?hk_database::central:hk_database::local));
 p_database->set_storagemode(ft_report, ((reportload->currentItem()==1)?hk_database::central:hk_database::local),
                                  ((reportstore->currentItem()==1)?hk_database::central:hk_database::local));
 p_database->set_automatic_data_update(automaticupdatefield->currentItem()==0); 
    if (p_database && p_database->connection()->server_needs(hk_connection::NEEDS_MANUAL_CHARSET))
  {
  p_database->set_databasecharset(l2u(databaseencodingfield->currentText().utf8().data()));
  }
  
 p_database->save_configuration(); 
   KConfig* c=kapp->config();
    c->setGroup("Databasesetting");
    c->writeEntry("Geometry",geometry());
  accept();
}

void hk_kdedatabasesetting::encoding_changed()
{
 ok_button->setEnabled(true);
}
