// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.2 $

//***********************************************
//***  hk_kdedbdesigner PART definition             ***
//***********************************************
#include "hk_kdedbdesignerpart.h"
#include "hk_kdedbdesignerpartfactory.h"
#include <kinstance.h>
#include <kstdaction.h>
#include <kstandarddirs.h>
#include <kiconloader.h>
#include <kaction.h>
#include <klocale.h>
#include <kurl.h>
#include <qapplication.h>
#include <qclipboard.h>
#include <hk_drivermanager.h>
#include <hk_connection.h>
#include <hk_database.h>
#include <hk_datasource.h>
class hk_kdedbdesignerpartprivate
{
  public:
  hk_kdedbdesignerpartprivate()
  	{
		p_dbdesigner=NULL;
	}
   hk_kdedbdesigner* p_dbdesigner;
   KAction* p_addaction;

};

hk_kdedbdesignerpart::hk_kdedbdesignerpart(QWidget* pWidget, const char* /*widgetname*/,QObject* parent, const char* name, const QStringList &)
:KParts::ReadWritePart(parent,name)
{
    p_private=new hk_kdedbdesignerpartprivate;
    setInstance(hk_kdedbdesignerpartfactory::instance());
    p_private->p_dbdesigner = new hk_kdedbdesigner(pWidget);
//    p_private->p_dbdesigner->p_part=this;
    setWidget(p_private->p_dbdesigner);
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");
     setXMLFile(locate("data","hk_kdeclasses/hk_kdedbdesignerpart.rc"));

    p_private->p_addaction = new KAction(i18n("&Add datasource"),loader->loadIcon("gridadd22x22",KIcon::User),0,this,SLOT(add_action()),actionCollection(),"add");

    //connect (QApplication::clipboard(), SIGNAL(dataChanged()),this, SLOT(clipboarddata_has_changed()));
//clipboarddata_has_changed();
}

hk_kdedbdesignerpart::~hk_kdedbdesignerpart()
{
  delete p_private->p_addaction;
  delete p_private;
}



/*void hk_kdedbdesignerpart::show_dbdesignercolumndialog(void)
{
    p_private->p_dbdesigner->simpledbdesigner()->show_dbdesignercolumndialog();
}*/


void hk_kdedbdesignerpart::setReadWrite(bool rw)
{
    KParts::ReadWritePart::setReadWrite(rw);
}


bool hk_kdedbdesignerpart::openFile()
{
 // URL handling:   mysql:/user:password@host:port/databasename/datasourcetype/datasourcename
 // where datasourcetype is either tables or queries


    return true;
}


bool hk_kdedbdesignerpart::saveFile()
{
    return true;
}

hk_kdedbdesigner* hk_kdedbdesignerpart::dbdesigner(void)
{
 return p_private->p_dbdesigner;
}

void hk_kdedbdesignerpart::add_action(void)
{
p_private->p_dbdesigner->add_datasource();
}


KAboutData* hk_kdedbdesignerpart::createAboutData()
{
    KAboutData* a= new KAboutData("hk_kdedbdesignerpart", I18N_NOOP("hk_kdedbdesignerpart"),
        "0.1", I18N_NOOP("Database editor"),
        KAboutData::License_GPL,"(c) 2002-2004, Horst Knorr <hk_classes@knoda.org>");

    return a;

}







