// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.35 $

#include "hk_kdetable.h"
#include <hk_datasource.h>
#include <hk_database.h>
#include <hk_connection.h>
#include "hk_kdetable.moc"
#include "hk_kdetabledesign.h"
#include "hk_kdegrid.h"
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qtable.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include "hk_kdetoolbar.h"
#include <kparts/genericfactory.h>

#include <kmenubar.h>
#include <kiconloader.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kstandarddirs.h>
#include <klocale.h>
#include <kmdichildview.h>
/*
 *  Constructs a hk_kdetable which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 */

hk_kdetable::hk_kdetable(QWidget* w,const char* n,WFlags f):KParts::MainWindow(w,n,f),hk_dstable()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdetable::hk_kdetable");
    hkclassname("hk_kdetable");
#endif
    setName( "hk_kdetable" );
    resize( 596, 480 );
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");

    setXMLFile(locate("data","hk_kdeclasses/hk_kdetable.rc"));

    KLibFactory* p_factory= KLibLoader::self()->factory( "libhk_kdegridpart" );
    p_part=(KParts::ReadWritePart*) p_factory->create (this, "hk_kdegridpart", "KParts::ReadWritePart");
    if (!p_part)
    {
     show_warningmessage(hk_translate("Fatal error! Grid part could not be loaded!\nThis is a installation error. Check your installation!\
 Did you install knoda into the correct directory? Program will exit now...")); 
     exit(1);
    } 
     p_grid = (hk_kdegrid*)p_part->widget();
     p_grid->set_enablingbehaviour(true,true);
     
    p_design = new hk_kdetabledesign(this);
    p_autoclose =true;
    p_designaction=new KRadioAction(i18n("&Design mode"),"edit",0,this,SLOT(designbutton_clicked()),actionCollection(),"designmode");
    p_designaction->setEnabled(!runtime_only());
    p_printaction=new KAction(i18n("&Print"),"fileprint",0,p_grid,SLOT(print_grid()),actionCollection(),"print");
    p_printaction->setEnabled(false);
    p_viewaction=new KRadioAction(i18n("&View mode"),"exec",0,this,SLOT(tablebutton_clicked()),actionCollection(),"viewmode");
    p_closeaction=new KAction(i18n("&Close"),loader->loadIcon("exit",KIcon::User),0,this,SLOT(close_table()),actionCollection(),"closetable");
    p_designaction->setExclusiveGroup("mode");
    p_viewaction->setExclusiveGroup("mode");
    toolbar = new hk_kdetoolbar( this, "toolbar" );
    p_filterdefinitionaction=new KAction(i18n("Filterdefinition"),loader->loadIcon("filter",KIcon::User),0,toolbar,SLOT(filterdefinebutton_clicked()),actionCollection(),"filterdefinition");
    p_filterexecaction=new KToggleAction(i18n("Filterexecution"),loader->loadIcon("filterexec",KIcon::User),0,toolbar,SLOT(filterexecbutton_clicked()),actionCollection(),"filterexec");
    toolbar->set_filteractions(p_filterdefinitionaction,p_filterexecaction);
    set_nodesignmode(runtime_only());
    designbutton_clicked();
    setCentralWidget(p_design);
    createGUI(0L);
}


/*
 *  Destroys the object and frees any allocated resources
 */
hk_kdetable::~hk_kdetable()
{
// no need to delete child widgets, Qt does it all for us
    hk_datasource* d=p_grid->datasource();
    if (d!=NULL)
    {
        if (d->name().size()>0)p_grid->save_table(d->name(),false);
        if (!d->presentation())d->disable();
    }
}


void hk_kdetable::set_datasource(hk_datasource* d)
{
    hk_dsmodevisible::set_datasource(d);
    p_grid->set_datasource(d);
    p_design->set_datasource(d);
    toolbar->set_datasource(d);
    if (d!=NULL)
    {
        p_grid->load_table();
        toolbar->set_filter(QString::fromLocal8Bit(d->temporaryfilter().c_str()));
    }
	p_grid->set_font(hk_font());
    set_caption();
}


hk_datasource* hk_kdetable::datasource(void)
{

    return hk_dsmodevisible::datasource();
}


void hk_kdetable::designbutton_clicked(void)
{
    if (p_nodesignmode)
    {
        tablebutton_clicked();
        return;
    }
    hk_datasource* d=p_grid->datasource();
    if (d!=NULL)
    {
        if (d->is_enabled())d->store_changed_data();
        d->disable();
    }
    setCentralWidget(p_design);

    p_design->set_designmode();
    p_design->show();
    p_grid->hide();
    p_designmode=true;
    toolbar->set_designmode();
    p_designaction->setChecked(true);
    p_printaction->setEnabled(false);
//   p_filterdefinitionaction->setEnabled(false);
    createGUI(0L);
    set_caption();
}


void hk_kdetable::tablebutton_clicked(void)
{
    if (p_designmode &&p_design->datasource()!=NULL)
    {
        if (!p_design->alter_table())
        {
//toolbar->set_designmode();
            designbutton_clicked();
            return;
        }
    }
    hk_datasource* d=p_grid->datasource();
    if (d!=NULL) d->enable();
    setCentralWidget(p_grid);
    p_grid->show();
    p_design->hide();
    p_designmode=false;
    p_printaction->setEnabled(true);

    toolbar->set_viewmode();
    p_viewaction->setChecked(true);
    p_filterdefinitionaction->setEnabled(true);
    createGUI(p_part);
    set_caption();
}





bool  hk_kdetable::set_mode(enum_mode s)
{
    hk_dsmodevisible::set_mode(s);
    switch (s)
    {
	case hk_dsmodevisible::designmode :
								designbutton_clicked();
								break;
	case hk_dsmodevisible::viewmode :
								tablebutton_clicked();
								break;

    }

return true;
}

void hk_kdetable::before_source_vanishes(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdetable::before_source_vanishes");
#endif

    if (p_autoclose)
        close();
    else
    {
        hk_datasource* d=datasource();
        if (d!=NULL)d->disable();
        if (p_grid!=NULL) p_grid->set_datasource(NULL);
    }
}


void hk_kdetable::closeEvent ( QCloseEvent* e)
{
    if (   p_designmode) p_design->alter_table();
    QWidget::closeEvent(e);
   emit signal_closed(this);
}


void hk_kdetable::set_nodesignmode(bool d)
{
    p_nodesignmode=d;
    toolbar->set_nodesignmode(d);

}


void hk_kdetable::close_table(void)
{
    close();
}


void hk_kdetable::set_caption(void)
{
    hk_datasource* d=datasource();
    if (d!=NULL)
    {
        
	QString n=i18n("Table - ");
        n+=QString::fromLocal8Bit(d->name().c_str());
        n+=" (";
        hk_string driver=d->database()->name();
        n+=QString::fromLocal8Bit(driver.c_str());
        n+=")";
        setCaption(QString::fromLocal8Bit(d->database()->connection()->drivername().c_str())+" "+n);
	KMdiChildView* v=dynamic_cast<KMdiChildView*>(parent());
        if (v) v->setCaption(n);
    }

}


hk_dsgrid* hk_kdetable::grid()
{
return p_grid;
}
