// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
#include "hk_kderelationdialog.h"
#include "hk_kdedbdesigner.h"
#include <hk_datasource.h>
#include <hk_presentation.h>
#include <qtable.h>
#include <qpushbutton.h>



hk_kderelationdialog::hk_kderelationdialog( hk_kdedatasourceframe* master, hk_kdedatasourceframe* slave,QWidget* parent,  const char* name, bool modal, WFlags fl )
    : hk_kderelationdialogbase( parent, name, modal, fl )
{
p_masterdsframe=master;
p_slavedsframe=slave;
const int w=180;
grid->installEventFilter(this);
ok_button->installEventFilter(this);
cancel_button->installEventFilter(this);
grid->setColumnWidth(0,w);
grid->setColumnWidth(1,w);
grid->horizontalHeader()->setLabel(0,QString::fromLocal8Bit(
			master->designer()->presentation()
				->unique_datasourcename(master->datasource()->presentationnumber()).c_str()));

grid->horizontalHeader()->setLabel(1,QString::fromLocal8Bit(
			master->designer()->presentation()
				->unique_datasourcename(slave->datasource()->presentationnumber()).c_str()));

				
set_stringlist(&p_mastercollist,p_masterdsframe->datasource()->columns());
set_stringlist(&p_slavecollist,p_slavedsframe->datasource()->columns());
add_row();
//ok_button->setEnabled(false);
set_existing_fields();
connect(grid,SIGNAL(valueChanged(int,int)),this,SLOT(slot_data_changed(int,int)));
}



hk_kderelationdialog::~hk_kderelationdialog()
{
    // no need to delete child widgets, Qt does it all for us
}





void hk_kderelationdialog::add_row(void)
{

//cerr <<p_mastercollist<<endl;

QComboTableItem* masteritem=new QComboTableItem(grid,p_mastercollist);
QComboTableItem* slaveitem=new QComboTableItem(grid,p_slavecollist);
grid->setNumRows(grid->numRows()+1);
grid->setItem(grid->numRows()-1,0,masteritem);
grid->setItem(grid->numRows()-1,1,slaveitem);

}





void hk_kderelationdialog::set_stringlist(QStringList* strlist,list<hk_column*>* collist)
{
    strlist->clear();
    strlist->append("");
   list<hk_column*>::iterator it= collist->begin();
   while (it!=collist->end())
   {
       strlist->append(QString::fromLocal8Bit((*it)->name().c_str()));
     ++it;
   }

}





void hk_kderelationdialog::set_existing_fields(void)
{
if (!p_slavedsframe->datasource())return;
 list<hk_string>* slavefields=p_slavedsframe->datasource()->depending_on_thisfields();
 list<hk_string>* masterfields=p_slavedsframe->datasource()->depending_on_masterfields();
list<hk_string>::iterator slaveit=slavefields->begin();
list<hk_string>::iterator masterit=masterfields->begin();
while (slaveit!=slavefields->end())
	{
		((QComboTableItem*)(grid->item(grid->numRows()-1,0)))->setCurrentItem(textposition(&p_mastercollist,*masterit));
		((QComboTableItem*)(grid->item(grid->numRows()-1,1)))->setCurrentItem(textposition(&p_slavecollist,*slaveit));
		++slaveit;
		if (masterit!=masterfields->end()) ++masterit;
		add_row();
	}
}




int hk_kderelationdialog::textposition(QStringList* thelist,const hk_string& txt )
{
return thelist->findIndex(QString::fromLocal8Bit(txt.c_str()));
}



int hk_kderelationdialog::masterindex(const QString& string)
{
return textposition(&p_mastercollist,string.local8Bit().data());
}




int hk_kderelationdialog::slaveindex(const QString& string)
{
return textposition(&p_slavecollist,string.local8Bit().data());
}




void hk_kderelationdialog::ok_button_clicked(void)
{
p_slavedsframe->datasource()->clear_depending_fields();
 p_slavedsframe->datasource()->set_depending_on_presentationdatasource(
 		p_masterdsframe->datasource()->presentationnumber(),
		p_slavedsframe->datasource()->depending_on_react_on_data_changes(),
		p_slavedsframe->datasource()->dependingmode()
		);

for (int row=0;row<grid->numRows()-1;++row)
  {
    hk_string mastertxt=grid->item(row,0)->text().local8Bit().data();
    hk_string slavetxt=grid->item(row,1)->text().local8Bit().data();
    if (mastertxt.size()>0 && slavetxt.size()>0)
        p_slavedsframe->datasource()->add_depending_fields(slavetxt,mastertxt,true);
  }

accept();
}




void hk_kderelationdialog::slot_data_changed(int row, int /*col*/)
{
  if (row==grid->numRows()-1 
  	&& grid->item(row,0)
	&&  !grid->item(row,0)->text().isEmpty() 
	&& !grid->item(row,1)->text().isEmpty())
  	{
		add_row();
	}

ok_button->setEnabled(grid->item(0,0)&&!grid->item(0,0)->text().isEmpty() &&!grid->item(0,1)->text().isEmpty() );
}





void hk_kderelationdialog::keyPressEvent(QKeyEvent* /*event*/)
{
    /*if (event->key()==Key_Delete)
    {
        delete_rows();
    }*/



}	



void hk_kderelationdialog::delete_rows(void)
{
 //cerr <<"hk_kderelationdialog::delete_rows"<<endl;
 int beginrow=grid->selection(0).topRow();
 int endrow=grid->selection(0).bottomRow();
 if (endrow==grid->numRows()-1) --endrow;
if (beginrow>-1&&endrow>=beginrow)
{
QMemArray<int> a(endrow-beginrow+1);
int c=0;//cerr <<"a new ="<<endrow-beginrow+1<<endl;
	for (int i=beginrow;i<=endrow;++i)
	{
	 a[c]=i;//cerr <<"a["<<c<<"]="<<i<<endl;
	 ++c;
	}
	grid->removeRows(a);
}
else
{
//cerr <<"delete_row "<<grid->currentRow()<<endl;
if (grid->currentRow()>-1 &&grid->currentRow()<grid->numRows()-1) 
	grid->removeRow(grid->currentRow());
}

}




bool hk_kderelationdialog::eventFilter(QObject* object,QEvent* e)
{
 QKeyEvent* event=dynamic_cast<QKeyEvent*>(e);
 if (event  && event->key()==Qt::Key_Delete && event->type()==QEvent::KeyRelease)
   {
       delete_rows(); 
       //event->accept();
       return true;
   }
  else return hk_kderelationdialogbase::eventFilter(object,e);
}


