// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************

#ifndef HK_KDEQUERY_H
#define HK_KDEQUERY_H

#include <qvariant.h>
#include <kparts/mainwindow.h>
#include <kate/view.h>
#include <kate/document.h>

#include "hk_dsquery.h"
#include "hk_datasource.h"
#include "hk_database.h"
class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QButtonGroup;
class QTable;
class QToolButton;
class QMultiLineEdit;
class hk_kdetoolbar;
class hk_kdegrid;
class hk_kdegridpart;

class hk_kdequeryprivate;

/**
 *
 *@short KDE high level widget to define queries and see the result.
 *@version $Revision: 1.27 $
 *@author Horst Knorr (hk_classes@knoda.org)

 *hk_kdequery is a high level widget to define queries and see the result.
 *In this mode of development it has a field to enter the SQL query and a grid which shows the
 * resulting data if there is any. hk_kdequery also handles actionqueries correctly.
 */

 
class hk_kdequery : public KParts::MainWindow ,public hk_dsquery
{
    Q_OBJECT

        public:
        hk_kdequery(QWidget* w=0,const char* n=0,WFlags f=0);
        ~hk_kdequery();
        virtual bool            set_mode(enum_mode s);
/**
 *returns true if the sqlwindow or the qbe window is shown. Else returns false (when the result data is shown)
 */
        bool in_designmode(void) const ;
        virtual void set_datasource(hk_datasource*);
 
/**
 *when the datasource vanishes (i.e. will be destroyed) and autoclose is true, the hk_kdequery will be
 *closed otherwise it still is on your screen.
 */
        void set_autoclose(bool c);

/**
 *if the designwindow should not be shown set this true. Default is false.
 */
        void set_nodesignmode(bool n);

        bool save_query(const hk_string& n="",bool ask=true);
        bool load_query(void);
	hk_dsgrid *grid(void);
	virtual hk_qbe*  qbe(void);
    signals:
        void signal_closed(QWidget*);
    
    public slots:
        void designbutton_clicked(void);
        void querybutton_clicked(void);
        void query_changed(void);
        void savebutton_clicked(void);
        void saveasbutton_clicked(void);
        void close_query(void);
        void print(void);
	void action_useqbe(void);
virtual void show ();
virtual void showMaximized ();


    protected:
        virtual void before_source_vanishes(void);
        virtual void closeEvent ( QCloseEvent* e);
        void    keyPressEvent ( QKeyEvent * e );

    protected slots:	
	void qbe_has_changed(void);

    private:
        void set_caption(void);
	void internal_set_designmode(void);
	void internal_set_viewmode(void);
//    QMultiLineEdit* p_design;
	
	hk_kdequeryprivate* p_private;

};
#endif
