// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.26 $

#include <hk_kdemessages.h>
#include <kmessagebox.h>
#include "hk_kdepassworddialog.h"
#include "hk_kdenewpassworddialog.h"
#include <kapp.h>
#include <kglobal.h>
#include <klocale.h>
#include <qinputdialog.h>
#include "hk_kdedriverdialog.h"
#include "hk_kdeform.h"
#include "hk_kdesimpleform.h"
#include "hk_kdereport.h"
#include "hk_kdesimplereport.h"
#include "hk_kdetable.h"
#include "hk_kdequery.h"
#include "knodamaindockwindow.h"
#include <qapplication.h>
#include <qevent.h>
#include <qkeycode.h>
#include <qmainwindow.h>
#include <qwidget.h>
#include <qmenubar.h>
#include <qmime.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include <hk_drivermanager.h>











hk_kdetextdialog::hk_kdetextdialog( QWidget* parent, const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )

{
    if ( !name )
	setName( "hk_kdetextdialog" );
    setSizeGripEnabled( TRUE );
    hk_kdetextdialogLayout = new QVBoxLayout( this, 4, 6, "hk_kdetextdialogLayout");

    textlabel = new QLabel( this, "textlabel" );
    hk_kdetextdialogLayout->addWidget( textlabel );

    textfield = new QLineEdit( this, "textfield" );
    textfield->setMinimumSize( QSize( 400, 0 ) );
    hk_kdetextdialogLayout->addWidget( textfield );

    Layout1 = new QHBoxLayout( 0, 0, 6, "Layout1");
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout1->addItem( spacer );

    buttonOk = new QPushButton( this, "buttonOk" );
    buttonOk->setAutoDefault( TRUE );
    buttonOk->setDefault( TRUE );
    Layout1->addWidget( buttonOk );

    buttonCancel = new QPushButton( this, "buttonCancel" );
    buttonCancel->setAutoDefault( TRUE );
    Layout1->addWidget( buttonCancel );
    hk_kdetextdialogLayout->addLayout( Layout1 );
    languageChange();
    resize( QSize(408, 85).expandedTo(minimumSizeHint()) );
    buttonOk->setEnabled(false);
    // signals and slots connections
    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect( textfield, SIGNAL( textChanged(const QString&) ), this, SLOT( text_changed(const QString&) ) );
}

/*
 *  Destroys the object and frees any allocated resources
 */
hk_kdetextdialog::~hk_kdetextdialog()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void hk_kdetextdialog::languageChange()
{
    setCaption( tr( "MyDialog" ) );
    textlabel->setText( tr( "Please enter:" ) );
    buttonOk->setText( tr( "&OK" ) );
    buttonOk->setAccel( QKeySequence( QString::null ) );
    buttonCancel->setText( tr( "&Cancel" ) );
    buttonCancel->setAccel( QKeySequence( QString::null ) );
}



void hk_kdetextdialog::text_changed(const QString& t)
{
hk_string txt=trim(t.local8Bit().data());
buttonOk->setEnabled(txt.size()>0);
}

void hk_kdewarning(const hk_string& w)
{
    KMessageBox::information(0,QString::fromLocal8Bit (w.c_str()),i18n("Information"),0,0);
}


bool hk_kdeyesno_dialog(const hk_string& w,bool )
{
    int ret;
    QString a=i18n("Please decide");
    ret=KMessageBox::questionYesNo(0,QString::fromLocal8Bit (w.c_str()),a);
    if (ret==3)    return true;
    else    return false;
}


hk_string hk_kdestringvaluedialog(const hk_string& st)
{
    //bool ok;
    hk_kdetextdialog* txtdlg=new hk_kdetextdialog(0,0,true);
    txtdlg->textlabel->setText(QString::fromLocal8Bit(st.c_str()));
    txtdlg->exec();
    if (txtdlg->result()==QDialog::Accepted)
    {
        return trim(txtdlg->textfield->text().local8Bit().data());
    }
    else return "";
}


bool hk_kdenewpassworddlg(hk_string& s)
{
    hk_string np;

    hk_kdenewpassworddialog* dlg= new hk_kdenewpassworddialog(0,0,true);
    dlg->exec();

    if (dlg->result()==QDialog::Accepted)
    {
        if (dlg->passwordfield->text()==dlg->repeatfield->text())
        {
            s=dlg->passwordfield->text().local8Bit().data();
            delete dlg;
            return true;
        }
    }
    delete dlg;
    return false;
}

hk_form* new_form(hk_database* db,hk_class* parent)
{

  hk_kdeform* f=NULL;
  knodamaindockwindow* knoda=dynamic_cast<knodamaindockwindow*>(parent);
  if (knoda)
  {
   f=knoda->new_form();
  }
  else
  f=new hk_kdeform(dynamic_cast<QWidget*>(parent),0,QWidget::WDestructiveClose);
  
  
  if (!f) return NULL;
  f->set_database(db);
  f->set_designmode();
  if (hk_visible::open_maximized_windows())f->showMaximized();
  else f->show();
  return f->simpleform();
}

hk_report* new_report(hk_database* db,hk_class* parent)
{

  hk_kdereport* f=NULL;
  knodamaindockwindow* knoda=dynamic_cast<knodamaindockwindow*>(parent);
  if (knoda)
  {
   f=knoda->new_report();
  }
  else
  f=new hk_kdereport(dynamic_cast<QWidget*>(parent),0,QWidget::WDestructiveClose);
  if (!f) return NULL;
  f->set_database(db);
  if (hk_visible::open_maximized_windows())f->showMaximized();
  else f->show();
  f->set_designmode();

  return f->simplereport();
}

hk_dstable* new_table(hk_class* parent)
{
  hk_kdetable *f=NULL;
  knodamaindockwindow* knoda=dynamic_cast<knodamaindockwindow*>(parent);
  if (knoda)
  {
   f=knoda->new_table();
  }
  else
  f= new hk_kdetable(dynamic_cast<QWidget*>(parent),0,QWidget::WDestructiveClose);
  if (!f) return NULL;
  if (hk_visible::open_maximized_windows())f->showMaximized();
  else f->show();
  return f;
}

hk_dsquery* new_query(hk_class* parent)
{

  hk_kdequery* f=NULL;
  knodamaindockwindow* knoda=dynamic_cast<knodamaindockwindow*>(parent);
  if (knoda)
  {
   f=knoda->new_query();
  }
  else
  f= new hk_kdequery(dynamic_cast<QWidget*>(parent),0,QWidget::WDestructiveClose);
  if (!f) return NULL;  
  if (hk_visible::open_maximized_windows())f->showMaximized();
  else f->show();
return f;
}


void set_kdestandarddialogs(void)
{
    hk_class::set_yesnodialog(&hk_kdeyesno_dialog);
    hk_class::set_warningmessage(&hk_kdewarning);
    hk_connection::set_passworddialog(&hk_kdepassworddlg);
    hk_connection::set_newpassworddialog(&hk_kdenewpassworddlg);
    hk_drivermanager::set_driverselectdialog( &hk_kdedriverselectdialog);
    hk_drivermanager::set_stringvaluedialog( &hk_kdestringvaluedialog);
    hk_drivermanager::set_translatefunction(&hk_kdetranslate);
    hk_database::set_new_formvisiblefunction(&new_form);
    hk_database::set_new_reportvisiblefunction(&new_report);
    hk_database::set_new_tablevisiblefunction(&new_table);
    hk_database::set_new_queryvisiblefunction(&new_query);

}


void hk_kdepassworddlg(hk_connection* connection,struct_connectionfields* c)
{
    hk_kdepassworddialog* d=new hk_kdepassworddialog(connection,0,0,c);
    d->exec();
    delete d;

}


hk_string hk_kdetranslate(const hk_string& t)
{
    QString erg=i18n(t.c_str());
    return (erg.local8Bit().data());
}


hk_string hk_kdedriverselectdialog(void)
{
    hk_kdedriverdialog* c = new hk_kdedriverdialog();
    c->exec();
    hk_string p=c->drivername();
    delete c;
    return p;
}
