// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
#ifndef HK_KDEBUTTON_H
#define HK_KDEBUTTON_H
#include "hk_button.h"
#include <qpushbutton.h>
class hk_form;
class hk_kdeform;
class hk_kdereport;
/**
 *
 *@short base class for buttons in forms.
 *@version 0.1
 *@author Horst Knorr (hk_classes@knoda.org)
 */
class hk_kdebutton :public QPushButton,public hk_button
{
    Q_OBJECT
        public:
        hk_kdebutton(QWidget*wid,hk_form*f=NULL) ;
        virtual ~hk_kdebutton(void);

    public slots:
        void button_clicked(void);

    protected:
        virtual bool widget_specific_coordinates(uint px,uint py,uint pwidth,uint pheight);
        virtual bool widget_specific_open_form(void);
        virtual bool widget_specific_close_form(void);
        virtual bool widget_specific_open_table(void);
        virtual bool widget_specific_open_query(void);
        virtual bool widget_specific_preview_report(void);

        virtual void widget_specific_label_changed(void);
        virtual void widget_specific_font_changed(void);
        virtual void resizeEvent (QResizeEvent *);
        virtual void moveEvent ( QMoveEvent * ) ;
        virtual void widget_specific_backgroundcolour_changed(const hk_colour& oldcolour);
        virtual void widget_specific_foregroundcolour_changed(const hk_colour& oldcolour);
        virtual void            mouseDoubleClickEvent(QMouseEvent*);

    private:
        void    reposition(void);
        hk_kdeform* find_existing_form(void);
        hk_kdereport* find_existing_report(void);

};
#endif
