/*
 * Copyright (C) 2006 Julien Maillard <julien.maillard@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "kswitchmain.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kpassdlg.h>
#include <qlabel.h>

#include <netswitch.h>
#include "kswitchsu.h"
#include <string.h>
#include <stdlib.h>

static const char description[] =
    I18N_NOOP("A KDE network manager based on libnetswitch");

static const char version[] = "0.0.1";

static KCmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
    KCmdLineLastOption
};

void suWindow(char **text, enum CONN_TYPE type )
{
	kswitchsu *suwidget = 0;

	suwidget = new kswitchsu();
	if( type == SU ){
	suwidget->label->setText(QString("This application requires Root permissions.\nPlease enter the root password."));
	}
	else{
		suwidget->label->setText(QString("This application requires Root permissions.\nPlease enter your current user password."));
	}
	suwidget->show();
	
	if( suwidget->exec() == QDialog::Accepted ){
		*text = (char*)  malloc(sizeof(suwidget->suPassword->password()));
		strcpy(*text, suwidget->suPassword->password() );
	}
	else {
		exit(0);
	}
	
}


int main(int argc, char **argv)
{
	int i;
    KAboutData about("knetswitch", I18N_NOOP("knetswitch"), version, description,
		     1, "(C) 2006 Julien Maillard", 0, "http://netswitch.tuxfamily.org", "julienm@tuxfamily.org");
    about.addAuthor( "Julien Maillard", "Main developper of knetswitch", "julienm@tuxfamily.org" );
    about.addAuthor( "Oliver Rossiny", "developper of knetswitch","mrfreeze@tuxfamily.org");

    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;
    kswitchmain *mainWin = 0;


        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

        /// @todo do something with the command line args here
	i = netswitch_init( suWindow );
	if( i == 0 )
	{
		KMessageBox::error(0,"The password you gave is wrong.\n The application will finish.","Bad Password");
		exit(0);
	}
	if( i==-1 ){
		exit(0);
	}

        mainWin = new kswitchmain();
        app.setMainWidget( mainWin );
	mainWin->widget = NULL;
	mainWin->refresh();
        mainWin->show();
	
        args->clear();

	
    // mainWin has WDestructiveClose flag by default, so it will delete itself.
   	 return app.exec();
}

