/*
 * Copyright (C) 2006 Julien Maillard <julien.maillard@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "kswitchwidget.h"
#include "kswitchedit.h"
#include <netswitch.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <qlabel.h>
#include <netswitch.h>
#include <kprogress.h>
#include <kpushbutton.h>
#include <klineedit.h>
#include <qtabwidget.h>
#include <qcheckbox.h>
#include <knuminput.h>
#include <qradiobutton.h>

kswitchwidget::kswitchwidget(QWidget* parent, const char* name, WFlags fl)
    : Form1(parent,name,fl)
{

}

kswitchwidget::~kswitchwidget()
{}

void kswitchwidget::refreshProfiles()
{

	int i=1;
	
	profiles_list  *profile, *firstprofile = iface->profiles;
	profile = firstprofile;
	
	iface_info *info;
	info = netswitch_info(iface);

 	profilesCombobox->clear();
	profilesCombobox->insertItem("Disable");

	profile = profile->next;
	if( profile != firstprofile ){
		do{	
				if( profile->name != 0 )
					profilesCombobox->insertItem(profile->name);
	 			profile = profile->next;
				i++;
 		}while(profile != firstprofile );
		profilesCombobox->setCurrentItem(1);
	}
	
	if( profile->name == 0 && profile == firstprofile){
			if( info->status == 1 ){
				profilesCombobox->insertItem("User defined");
				profilesCombobox->setCurrentItem(i);
			}
			else{
				profilesCombobox->setCurrentItem(0);
			}
			editButton->setDisabled(1);
			delButton->setDisabled(1);
			applyButton->setDisabled(1);
	}
	else{
 		profilesCombobox->insertItem(profile->name);
		profilesCombobox->setCurrentItem(1);
	}
	
	//iface_info_free(info);
}


void kswitchwidget::run()
{
	iface_info *info;
	for(;;){
		info = netswitch_info(iface);
		if( info->status == 0 ){
			labelinfos->setText(QString("Interface down\n\nMAC address: %1\n").arg(info->hwaddr));
		}
		else{
			if( iface->type == WIRELESS ){
				labelinfos->setText(QString("ESSID: %1\nMAC address: %2\nIP address: %3").arg(info->wifiessid).arg(info->hwaddr).arg(info->ipaddr));
				signalBar->setProgress(info->wifilink);
			}else{
				labelinfos->setText(QString("MAC address: %1\nIP address: %2").arg(info->hwaddr).arg(info->ipaddr));
			}
		}
		sleep(1);
	}
}

void kswitchwidget::deleteprofile()
{
	char *del_profile;
	del_profile = (char*) malloc((profilesCombobox->currentText()).length() + 1);
	strcpy(del_profile,(profilesCombobox->currentText()).utf8());
	 switch( QMessageBox::information( this, "Knetswitch",QString("Do you want to delete the profile %1 ?").arg(del_profile),"&Yes", "Cancel",0, 2 ) ) { 
   	 case 0: 
		netswitch_delete(iface,del_profile );
		refreshProfiles();
      	  break;
	}
	
	
	//free(del_profile);	
}

void kswitchwidget::comboboxaction()
{
	int i=0;
	iface_info *info;

	if( profilesCombobox->currentItem() == 0 || strcmp(profilesCombobox->currentText(),"User defined") == 0 )
	{
		i = 1;
 	}
	editButton->setDisabled(i);
	delButton->setDisabled(i);
	if( profilesCombobox->currentItem() == 0 ){
		info = netswitch_info(iface);
		if( info->status == 1)
			i = 0;
	}
	applyButton->setDisabled(i);
}


void kswitchwidget::applyprofile()
{
	maindlg->setDisabled(1);
 	labelinfos->setText("Profile up in progress...");
	char *active_profile = new char;
	strcpy(active_profile,(profilesCombobox->currentText()).ascii());
	KMessageBox::information(0,QString("Your profile %1 is being up.\nThis can take few minutes.").arg(active_profile),"Install Profile");
	if( profilesCombobox->currentItem() == 0 ){
		netswitch_inactive( iface );
	}
	else{
		netswitch_active(iface, active_profile);
	}
	maindlg->setDisabled(0);
	maindlg->refresh();
}

void kswitchwidget::addprofile()
{
	setDisabled(1);
	kswitchedit *widgetedit = 0;
	widgetedit = new kswitchedit();
	widgetedit->iface = iface;
	widgetedit->parentwidget = this ;
	widgetedit->maindlg = maindlg;
	widgetedit->deviceText->setText(iface->iface);
	if(iface->type == ETHERNET)
		widgetedit->mainTab->removePage(widgetedit->TabPage);
	widgetedit->show();
	refreshProfiles();
}

void kswitchwidget::editprofile()
{
	profile *editing_profile;
	char *current_profile;
	kswitchedit *widgetedit = 0;
	widgetedit = new kswitchedit();

	current_profile = (char*) malloc((profilesCombobox->currentText()).length() + 1);
	strcpy(current_profile,(profilesCombobox->currentText()).utf8());
	editing_profile = netswitch_get(iface, current_profile);
	
	widgetedit->profilenameText->setText(current_profile);

	setDisabled(1);	
	widgetedit->parentwidget = this ;
	widgetedit->maindlg = maindlg;

	widgetedit->deviceText->setText(iface->iface);
	if( editing_profile->ipaddr == 0 ){
		widgetedit->dhcpCheck->setChecked(1);

	}
	else{
		/* Network Tab */
		widgetedit->dhcpCheck->setChecked(0);
		widgetedit->ipaddressLabel->setEnabled(1);
		widgetedit->ipaddressText->setEnabled(1);
		widgetedit->bitsmaskLabel->setEnabled(1);
		widgetedit->bitsmaskSpin->setEnabled(1);
		widgetedit->broadcastLabel->setEnabled(1);
		widgetedit->broadcastText->setEnabled(1);
		widgetedit->gatewayLabel->setEnabled(1);
		widgetedit->gatewayText->setEnabled(1);
	
		widgetedit->ipaddressText->setText(editing_profile->ipaddr);
		widgetedit->bitsmaskSpin->setValue(editing_profile->netmask);
		widgetedit->broadcastText->setText(editing_profile->broadcast);
		widgetedit->gatewayText->setText(editing_profile->gateway);

		/* DNS TAB */
		widgetedit->usednsdhcpCheck->setDisabled(1);
		widgetedit->domainLabel->setEnabled(1);
		widgetedit->domainText->setEnabled(1);
		widgetedit->customdnsCheck->setEnabled(1);
	}

	if(editing_profile->peerdns == 0)
		widgetedit->usednsdhcpCheck->setChecked(1);
	widgetedit->domainText->setText(editing_profile->domain);

	
	if( editing_profile->nameservers != 0 ){
		widgetedit->customdnsCheck->setChecked(1);
		if( editing_profile->nameservers[0] != 0){
			widgetedit->dns1Text->setText(editing_profile->nameservers[0]);
 			if( editing_profile->nameservers[1] != 0){
 				widgetedit->dns2Text->setText(editing_profile->nameservers[1]);
 				if( editing_profile->nameservers[2] != 0){
 					widgetedit->dns3Text->setText(editing_profile->nameservers[2]);
 					if( editing_profile->nameservers[3] != 0){
 						widgetedit->dns4Text->setText(editing_profile->nameservers[3]);
 					}
				}
			}
		}
	}
	if(iface->type == ETHERNET){
		widgetedit->mainTab->removePage(widgetedit->TabPage);
	}else{
	widgetedit->nicknameText->setText(editing_profile->nickname);
	widgetedit->essidText->setText(editing_profile->essid);


	switch( editing_profile->mode ){
		case ADHOC:
			widgetedit->modesCombobox->setCurrentItem(2);
			widgetedit->canalSpin->setBase(editing_profile->channel);
			break;
		case MANAGED:
			widgetedit->modesCombobox->setCurrentItem(1);
			widgetedit->canalSpin->setDisabled(1);
			break;
		case AUTO:
			widgetedit->modesCombobox->setCurrentItem(0);
			widgetedit->canalSpin->setBase(editing_profile->channel);
			break;
	}
	
	switch( editing_profile->key_mode ){
		case OPEN:
 			widgetedit->keymodeCombobox->setCurrentItem(1);
			widgetedit->keymodeLabel->setText("WEP keys can be specified in two different ways:\nHexadecimal case: Enter the key directly(between 16 and 32 carcaters)\nASCII string case: Prepend 's': string before your key\n(between 8 and 16 caracters)\nExample: s:E7fdgYKf");
			break;
		case RESTRICTED:
 			widgetedit->keymodeCombobox->setCurrentItem(2);
			break;
		case WPA:
 			widgetedit->keymodeCombobox->setCurrentItem(3);
			widgetedit->key1Label->setDisabled(1);
			widgetedit->key1Text->setDisabled(1);
			widgetedit->key1Radio->setDisabled(1);
			widgetedit->key2Label->setDisabled(1);
			widgetedit->key2Text->setDisabled(1);
			widgetedit->key2Radio->setDisabled(1);
			widgetedit->key3Label->setDisabled(1);
			widgetedit->key3Text->setDisabled(1);
			widgetedit->key3Radio->setDisabled(1);
			widgetedit->key4Label->setDisabled(1);
			widgetedit->key4Text->setDisabled(1);
			widgetedit->key4Radio->setDisabled(1);
			widgetedit->keymodeLabel->setText("WPA is not yet avaible");
			break;
		case OFF:
 			widgetedit->keymodeCombobox->setCurrentItem(0);
			widgetedit->key1Label->setDisabled(1);
			widgetedit->key1Text->setDisabled(1);
			widgetedit->key1Radio->setDisabled(1);
			widgetedit->key2Label->setDisabled(1);
			widgetedit->key2Text->setDisabled(1);
			widgetedit->key2Radio->setDisabled(1);
			widgetedit->key3Label->setDisabled(1);
			widgetedit->key3Text->setDisabled(1);
			widgetedit->key3Radio->setDisabled(1);
			widgetedit->key4Label->setDisabled(1);
			widgetedit->key4Text->setDisabled(1);
			widgetedit->key4Radio->setDisabled(1);
			break;
	}
	
	if( editing_profile->keys != 0 ){
		if( editing_profile->keys[0] != 0){
			widgetedit->key1Text->setText(editing_profile->keys[0]);
			if( editing_profile->keys[1] != 0){
				widgetedit->key2Text->setText(editing_profile->keys[1]);
				if( editing_profile->keys[2] != 0){
					widgetedit->key3Text->setText(editing_profile->keys[2]);
					if( editing_profile->keys[2] != 0){
						widgetedit->key4Text->setText(editing_profile->keys[2]);
	}}}}}

	switch( editing_profile->sendkey ){
		case 2:
			widgetedit->key2Radio->setChecked(1);
			break;
		case 3:
			widgetedit->key3Radio->setChecked(1);
			break;
		case 4:
			widgetedit->key4Radio->setChecked(1);
			break;
		default:
			widgetedit->key1Radio->setChecked(1);
			break;
		
	}
	}
	widgetedit->iface = iface;
	widgetedit->show();

}





/*$SPECIALIZATION$*/


#include "kswitchwidget.moc"

