/*
 * Copyright (C) 2006 Julien Maillard <julien.maillard@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "kswitchmain.h"
#include "kswitchwidget.h"
#include "kswitchsu.h"
#include <qlabel.h>
#include <netswitch.h>
#include <kprogress.h>
#include "kmessagebox.h"
#include <kaboutkde.h>
#include <kaboutapplication.h>
#include <qlayout.h>

kswitchmain::kswitchmain(QWidget* parent, const char* name, WFlags fl)
    : Maindlg(parent,name,fl)
{

}

kswitchmain::~kswitchmain()
{}

void kswitchmain::hideWindow()
{
	lower();
}

void kswitchmain::refresh()
{
	int x = 0;
 
	struct widget_t *widgettmp, *widgetcurrent;
	if( widget !=  NULL){
		widgetcurrent = widget;
		while( widgetcurrent != NULL){
 				widgetcurrent->widget->close();
				widgetcurrent = widgetcurrent->next;
		}
	}
	widget = NULL;

	
	netswitch *m, *n = netswitch_new();
	netswitch_profiles_list(n);
	netswitch_active_profiles(n);
				
	m = n;
	do{ 
		if( m->type == WIRELESS ){
	
			kswitchwidget *wifiwidget = 0;
			wifiwidget = new kswitchwidget( this );
			widgettmp = (struct widget_t*) malloc(sizeof(struct widget_t ));
			widgettmp->next = NULL;
			widgettmp->widget = wifiwidget;
			if( widget!= NULL ){
				widgetcurrent->next=widgettmp;
				widgetcurrent = widgettmp;
			}
			else{
				widget = widgettmp;
				widgetcurrent = widgettmp;
			}
			
			wifiwidget->move(x,40);
			wifiwidget->pixWired->hide();
			if(m->profiles->name != 0 ){
				wifiwidget->labelprofilesWifi->setText(QString("WIRELESS INTERFACE\nCurrent profile: %1").arg(m->profiles->name));
			}else{
				wifiwidget->labelprofilesWifi->setText(QString("WIRELESS INTERFACE\nNo profile up"));
			}
			wifiwidget->iface = m;
 			wifiwidget->maindlg = this;
			wifiwidget->refreshProfiles();
			wifiwidget->start();

			wifiwidget->show();
					

		}
		else {
			kswitchwidget *wiredwidget = 0;
			wiredwidget = new kswitchwidget( this );
			widgettmp = (struct widget_t*) malloc(sizeof(struct widget_t ));
			widgettmp->next = NULL;
			widgettmp->widget = wiredwidget;
			if( widget!= NULL ){
				widgetcurrent->next=widgettmp;
				widgetcurrent = widgettmp;
			}
			else{
				widget = widgettmp;
				widgetcurrent = widgettmp;
			}

			wiredwidget->move(x,40);
			if(m->profiles->name != 0 ){
				wiredwidget->labelprofilesWifi->setText(QString("WIRED INTERFACE\nCurrent profile: %1").arg(m->profiles->name));
			}else{
				wiredwidget->labelprofilesWifi->setText(QString("WIRED INTERFACE\nNo profile up"));
			}
			wiredwidget->pixWifi->hide();
			wiredwidget->signalBar->hide();
			wiredwidget->iface = m;
  			wiredwidget->maindlg =  this;
			wiredwidget->refreshProfiles();
			wiredwidget->start();

			wiredwidget->show();
		}
		x = x + 240;
		m = m->next;
	} while ( m!=n );
	setFixedSize(x,450);
}

void kswitchmain::appaboutdialog()
{
	KAboutApplication *aboutapp = new KAboutApplication();
	aboutapp->setProgramLogo(QString("pixmaps/netswitch-77x77.png"));
	aboutapp->show();
}

void kswitchmain::kdeaboutdialog()
{
	KAboutKDE *aboutkde = new KAboutKDE();
	aboutkde->show();
}




/*$SPECIALIZATION$*/


#include "kswitchmain.moc"

