/*
 * Copyright (C) 2006 Julien Maillard <julien.maillard@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "kswitchedit.h"
#include <kmessagebox.h>
#include <klineedit.h>
#include <netswitch.h>
#include <kcombobox.h>
#include <knuminput.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qradiobutton.h>

kswitchedit::kswitchedit(QWidget* parent, const char* name, bool modal, WFlags fl)
    : editWidget(parent,name, modal,fl)
{}

kswitchedit::~kswitchedit()
{}

/*$SPECIALIZATION$*/
void kswitchedit::reject()
{
   parentwidget->setEnabled(1);	
   QDialog::reject();
}

void kswitchedit::accept()
{
	
	char *profilename = new char;
	profile *profilecurrent = profile_new();
	/* gestion des erreurs */


	/* Sauvegarde des données */	
	if( strcmp(profilenameText->text().utf8(),"") != 0 ){
 		strcpy(profilename,(profilenameText->text()).utf8());
		if( dhcpCheck->isChecked() == FALSE ){
				profilecurrent->ipaddr = new char;
				strcpy(profilecurrent->ipaddr, ipaddressText->text().utf8());
			
				profilecurrent->netmask = bitsmaskSpin->value();
				profilecurrent->broadcast = new char;
				strcpy(profilecurrent->broadcast, broadcastText->text().utf8());
				profilecurrent->gateway = new char;
				strcpy(profilecurrent->gateway, gatewayText->text().utf8());
		}
		else{
			profilecurrent->ipaddr = new char[1];
			profilecurrent->ipaddr = 0;
		}

		if( usednsdhcpCheck->isChecked() == 1 )
			profilecurrent->peerdns = 0;
		if( dhcpCheck->isChecked() == FALSE || usednsdhcpCheck->isChecked() == TRUE ){
				profilecurrent->domain = new char;
				strcpy(profilecurrent->domain, domainText->text().utf8() );
		}
		else{
			profilecurrent->domain = new char[1];
			profilecurrent->domain = 0;
		}
	
		if( customdnsCheck->isChecked() == TRUE ){
			profilecurrent->nameservers = (char**) malloc(sizeof(char*)*5);
			if( strcmp(dns1Text->text().ascii(),"") != 0 ){
				profilecurrent->nameservers[0] = new char;
				strcpy(profilecurrent->nameservers[0],dns1Text->text().ascii());
				if( strcmp(dns2Text->text().ascii(),"") != 0 ){
					profilecurrent->nameservers[1] = new char;
					strcpy(profilecurrent->nameservers[1],dns2Text->text().ascii());
					if( strcmp(dns3Text->text().ascii(),"") != 0 ){
						profilecurrent->nameservers[2] = new char;
						strcpy(profilecurrent->nameservers[2],dns3Text->text().ascii());
						if( strcmp(dns4Text->text().ascii(),"") != 0 ){
							profilecurrent->nameservers[3] = new char;
							strcpy(profilecurrent->nameservers[3],dns4Text->text().ascii());
							profilecurrent->nameservers[4] = 0;
						}else{
							profilecurrent->nameservers[3] = 0;
						}
					}else{
						profilecurrent->nameservers[2] = 0;
					}
				}else{
				profilecurrent->nameservers[1] = 0;
				}
			}
			else{
				profilecurrent->nameservers = 0;
			}
		}
		else{
			profilecurrent->nameservers = 0;
		}

		if(iface->type == WIRELESS){
			if( strcmp(nicknameText->text().ascii(),"") != 0 ){
				profilecurrent->nickname = new char;
				strcpy(profilecurrent->nickname, nicknameText->text().utf8() );
			}
		
			if( strcmp(essidText->text().ascii(),"") != 0 ){
				profilecurrent->essid = new char;
				strcpy(profilecurrent->essid, essidText->text().utf8() );
				switch( modesCombobox->currentItem() ){
					case 0: 
						profilecurrent->mode = AUTO;
						profilecurrent->channel = canalSpin->value();
						break;
					case 1:
						profilecurrent->mode = MANAGED;
						break;
					case 2:
						profilecurrent->mode = ADHOC;
						profilecurrent->channel = canalSpin->value();
						break;
				}
			}

			switch( keymodeCombobox->currentItem() ){
					case 0:
						profilecurrent->key_mode = OFF;
 						break;
					case 3:
						profilecurrent->key_mode = WPA;
						break;
					case 1:
						profilecurrent->keys = (char**) malloc(sizeof(char*)*5);
						if( strcmp(key1Text->text().ascii(),"") != 0 ){
							if( key1Radio->isChecked() )
								profilecurrent->sendkey = 1;
							profilecurrent->keys[0] = new char;
							strcpy(profilecurrent->keys[0],key1Text->text().ascii());
							if( strcmp(key2Text->text().ascii(),"") != 0 ){
								if( key2Radio->isChecked() )
								profilecurrent->sendkey = 2;
								profilecurrent->keys[1] = new char;
								strcpy(profilecurrent->keys[1],key2Text->text().ascii());
								if( strcmp(key3Text->text().ascii(),"") != 0 ){
									if( key3Radio->isChecked() )
									profilecurrent->sendkey = 3;
									profilecurrent->keys[2] = new char;
									strcpy(profilecurrent->keys[2],key3Text->text().ascii());
									if( strcmp(key4Text->text().ascii(),"") != 0 ){
										if( key4Radio->isChecked() )
										profilecurrent->sendkey = 4;
										profilecurrent->keys[3] = new char;
										strcpy(profilecurrent->keys[3],key4Text->text().ascii());
										profilecurrent->keys[4] = 0;
									}else{
										profilecurrent->keys[3] = 0;
									}
								}else{
									profilecurrent->keys[2] = 0;
								}
							}else{
							profilecurrent->keys[1] = 0;
							}
						}
						else{
							profilecurrent->keys = 0;
						}
						profilecurrent->key_mode = OPEN;
						break;
					case 2:
						profilecurrent->keys = (char**) malloc(sizeof(char*)*5);
						if( strcmp(key1Text->text().ascii(),"") != 0 ){
							profilecurrent->keys[0] = new char;
							strcpy(profilecurrent->keys[0],key1Text->text().ascii());
							if( strcmp(key2Text->text().ascii(),"") != 0 ){
								profilecurrent->keys[1] = new char;
								strcpy(profilecurrent->keys[1],key2Text->text().ascii());
								if( strcmp(key3Text->text().ascii(),"") != 0 ){
									profilecurrent->keys[2] = new char;
									strcpy(profilecurrent->keys[2],key3Text->text().ascii());
									if( strcmp(key4Text->text().ascii(),"") != 0 ){
										profilecurrent->keys[3] = new char;
										strcpy(profilecurrent->keys[3],key4Text->text().ascii());
										profilecurrent->keys[4] = 0;
									}else{
										profilecurrent->keys[3] = 0;
									}
								}else{
									profilecurrent->keys[2] = 0;
								}
							}else{
							profilecurrent->keys[1] = 0;
							}
						}
						else{
							profilecurrent->keys = 0;
						}
						profilecurrent->key_mode = RESTRICTED;
						break;
			}
		}

		if( netswitch_install(iface, profilecurrent, profilename) == 0)
		{
			KMessageBox::error(0,"The profile was not saved correctly\n","Edit profile");
		}
		//profile_free(profilecurrent);
		free(profilename);
		parentwidget->setEnabled(1);
		maindlg->refresh();	
		QDialog::accept();
			
	}
	else{
		KMessageBox::error(0,"You must give a profile name\n","Edit profile");
	}	
}

void kswitchedit::modeselection()
{
	int i = 0;
	switch( modesCombobox->currentItem() ){
		case 0:
		case 2:
			i = 0;	
			break;
		case 1:
			i = 1;
			break;
	}
	
	canalSpin->setDisabled(i);
	canalLabel->setDisabled(i);

}

void kswitchedit::encselectiont()
{
	int i = 0;
	switch( keymodeCombobox->currentItem() ){
		case 0:
			i = 1;
			break;
		case 3:
			i = 1;
			keymodeLabel->setText("WPA is not yet avaible");
			break;
		case 1:
		case 2:
			i = 0;
			keymodeLabel->setText("WEP keys can be specified in two different ways:\nHexadecimal case: Enter the key directly(between 16 and 32 carcaters)\nASCII string case: Prepend 's': string before your key\n(between 8 and 16 caracters)\nExample: s:E7fdgYKf");
			break;
	}
		key1Text->setDisabled(i);
		key1Label->setDisabled(i);
		key1Radio->setDisabled(i);
		key2Text->setDisabled(i);
		key2Label->setDisabled(i);
		key2Radio->setDisabled(i);
		key3Text->setDisabled(i);
		key3Label->setDisabled(i);
		key3Radio->setDisabled(i);
		key4Text->setDisabled(i);
		key4Label->setDisabled(i);
		key4Radio->setDisabled(i);
}





#include "kswitchedit.moc"

