/***************************************************************************
 *   Copyright (C) 2005 by yodor   *
 *   yodor@developer.bg  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kiconloader.h>
#include <kmessagebox.h>
#include <qstring.h>
#include <qpainter.h>
#include <qimage.h>
#include <qpixmap.h>
#include <kimageeffect.h>
#include <kconfig.h>

#include "dockif.h"
#include <qpoint.h>
#include <kmessagebox.h>
#include <kpopupmenu.h>
#include <qrect.h>
#include <qpoint.h>
#include <qcolordialog.h>
#include <kapplication.h>
#include <qbitmap.h>

DockIf::DockIf(QWidget *parent, const char* name) : KSystemTray(parent, name)
{
	
	
	setWFlags(WRepaintNoErase);

	tipEnabled=true;
	useChart=false;
	
	tip = new TTip(this);


	c = new ChartFrame(3);
	c->resize(22,22);

	pbuf = new QPixmap(22,22);

	base = UserIcon("base");
	link_off = UserIcon("link_off");
	led.resize(10,8);

	loadLedColor();
	clear();

	
}
void DockIf::loadLedColor()
{
	KConfig *cfg = kapp->config();
	cfg->setGroup(dev_name);
	QColor def_color(18,142,10);
	led_color = cfg->readColorEntry("ledColor", &def_color);
	cfg->sync();
	createLedIcon(led_color);
	
}
void DockIf::createLedIcon(const QColor& clr)
{
	QSize sz = led.size();
	QColor c1(Qt::white);
	led.convertFromImage(KImageEffect::gradient(sz,c1,clr,KImageEffect::DiagonalGradient));
	QPainter p(&led);
	p.setPen(clr);
	p.drawRect(0,0,sz.width(),sz.height());

	QImage img = led.convertToImage();
	led_off.convertFromImage( KImageEffect::toGray(img) );

}
void DockIf::chooseLedColor()
{
	QColor c = QColorDialog::getColor(led_color);
	KConfig *cfg = kapp->config();
	cfg->setGroup(dev_name);
	cfg->writeEntry("ledColor", c);
	cfg->sync();
	createLedIcon(c);
}
DockIf::~DockIf()
{
	if (c)delete c;
	if (pbuf)delete pbuf;
	c=0;
	pbuf=0;
}

void DockIf::paintEvent (QPaintEvent *p)
{
 //	QWidget::paintEvent(p);
//  
	QPainter qpainter(this);
	qpainter.drawPixmap(0,0,*pbuf);
	//bitBlt(this,0,0,pbuf);


}

void DockIf::clear()
{
	if (!pbuf)return;

	pbuf->fill(this,0,0);
	
	QBitmap mask = pbuf->createHeuristicMask();
	pbuf->setMask(mask);	
	
}



void DockIf::update(const KNetDockIf *nif)
{

	//update child widgets
	tip->update(nif);
	Q_ULLONG in = nif->total.speed_in;
	Q_ULLONG out = nif->total.speed_out;
	c->appendValue(in,out);

	pbuf->fill(this,0,0);

	QPainter qpainter(pbuf);

	if (useChart && nif->devstate==UP)
	{
		//QRect r(0,0,22,22);
		QBitmap mask;
		
		pbuf->setMask(mask);	
		qpainter.drawPixmap(0,0,c->getBuffer());
		qpainter.end();
		repaint();
		return;
	}

	pbuf->fill(this,0,0);

	int step_val=4;
	double num_blocks = 5;

	int x=5;
	if (nif->devtype==WIFI)
	{
		x=2;
//  		for (int a=0;a<step_val*num_blocks;a+=step_val){
// 			//qpainter.drawPixmap(15,2+a,signalbar);
// 			qpainter.setPen(Qt::gray);
// 			qpainter.drawRect(15,2+a,5,3);
//  		}
	}

	qpainter.drawPixmap (x, 0, base);
	qpainter.drawPixmap (x, 11, base);
	
	if (nif->devstate==UP)
	{
		switch (nif->iconstatus)
		{
			case 1: 
				qpainter.drawPixmap (x+1, 12, led);	
				break;
			case 2:
				qpainter.drawPixmap (x+1, 1, led);	
				break;
			case 3:
				qpainter.drawPixmap (x+1, 1, led);	
				qpainter.drawPixmap (x+1, 12, led);	
				break;
		}
	}
	else if (nif->devstate==DOWN)
	{
		
		qpainter.drawPixmap (x+1, 1, led_off);	
		qpainter.drawPixmap (x+1, 12, led_off);	
	}
	else if (nif->devstate==NOLINK)
	{
		qpainter.drawPixmap (x, 4, UserIcon("link_off"));	
	}

	if (nif->devtype==WIFI)
	{
		if (nif->wstat.txpow==-1){
			qpainter.drawPixmap(x,4,UserIcon("link_off"));
		}
		else if (nif->wstat.link_qual>0) {
			
			QPen b = qpainter.pen();
			//b.setStyle(QBrush::SolidPattern);

			b.setColor(Qt::green);
			if (nif->wstat.link_qual<60){
				b.setColor(Qt::yellow);
			}
			if (nif->wstat.link_qual<40){
				b.setColor(Qt::red);
			}

			double inval = (num_blocks/100.0)*nif->wstat.link_qual;
			int y = 22;
			int vblock=0;
			while (vblock<inval) {
				y-=step_val;
				qpainter.setPen(b);
				qpainter.drawRect(16, y+1, step_val-1, 1);
				vblock++;
				qpainter.setPen(Qt::gray);
				qpainter.drawRect(15,y,5,3);
			}
			//qpainter.fillRect(21, (int)(22-num_blocks),21,24);
		}
	}
	qpainter.end();
	QBitmap mask = pbuf->createHeuristicMask();
	pbuf->setMask(mask);
	repaint();
}

bool DockIf::event(QEvent *ev)
{
	

	if (ev->type()==QEvent::Enter){

		move(0,0);
		QPoint loc = mapToGlobal(mapFromParent(QPoint(0,0)));
		QPoint np = QPoint(loc.x()-tip->width(),loc.y()-tip->height());
		if (np.x()<0)
		{
			np = QPoint(loc.x(),np.y());
		}
		if (np.y()<0)
		{
			np = QPoint(np.x(),loc.y());
		}
		tip->move(np);
		if (tipEnabled)
			tip->show();
		
	}
	else if (ev->type()==QEvent::Leave) {
		tip->hide();
	}
	
	
	return KSystemTray::event(ev);
}
void DockIf::toggleTip()

{
	tipEnabled=!tipEnabled;	
}

bool DockIf::isTipEnabled()
{
	return tipEnabled;
}
void DockIf::setUseChart(bool mode)
{
	useChart=mode;
}

bool DockIf::isUseChart()
{
	return useChart;
}


void DockIf::updateChartStyle(int st)
{
	c->setChartStyle(st);
	
}
