/***************************************************************************
 *   Copyright (C) 2007 by Todor Gyumyushev   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "speedframe.h"
#include <math.h>
#include <qlayout.h>

extern double getScaleString(const unsigned long long int value, QString& c);

SpeedFrame::SpeedFrame(QWidget *parent, const char *name)
 : QLabel(parent, name)
{
//	resize(80,40);
setAlignment(Qt::AlignHCenter);


	QHBoxLayout *h = new QHBoxLayout(this,2);

	QVBoxLayout *vlay = new QVBoxLayout(this,2);
	
	label = new QLabel(this);
	label->resize(80,20);
	label->setMinimumSize(label->size());
	label->setMaximumSize(label->size());
	//label->move(3,3);

	vlay->addWidget(label);

	//lcd->move(3,23);
	
	lcd = new QLCDNumber(this);
	lcd->resize(80,20);
	lcd->setMinimumSize(lcd->size());
	lcd->setMaximumSize(lcd->size());
	
	lcd->setFrameShape(QFrame::Panel);
	lcd->setFrameStyle(QFrame::Sunken);
	lcd->setSegmentStyle(QLCDNumber::Flat);
	lcd->setPaletteForegroundColor(Qt::white);
	lcd->setPaletteBackgroundColor(Qt::black);
	lcd->setMidLineWidth(2);
	vlay->addWidget(lcd);
	
	//setMinimumSize(86,46);
	//setMaximumSize(86,46);
	QLabel *l = new QLabel(this);
	h->addWidget(l);
	h->addLayout(vlay);
	h->addWidget(l);	
}


SpeedFrame::~SpeedFrame()
{
}
void SpeedFrame::update(const Q_ULLONG speed, bool bps)
{
		QString c="";
		double ret;
		ret = getScaleString(speed,c);
		lcd->display(ret);
		if (bps)
		label->setText(c+"bps");
		else
		label->setText(c+"Bps");

}

