/***************************************************************************
 *   Copyright (C) 2005 by Judd Baileys                                    *
 *   jbaileys@bigpond.net.au                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <klistview.h>
#include <knuminput.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kiconloader.h> 

#include "ethernetscan.h"
#include "networkdev.h"
#include "ethernetConfig.h"

#include <qlineedit.h>
#include <qtextstream.h>

#ifdef HAVE_SYS_SOCKIO_H
#include <sys/sockio.h>
#endif

#include <sys/types.h>
#include <sys/param.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/socket.h>
#include <errno.h>

#ifdef USE_SOLARIS
/* net/if.h is incompatible with STL on Solaris 2.6 - 2.8, redefine
   map in the header file because we don't need it. -- Simon Josefsson */
#define map junkmap
#endif
#  include <net/if.h>
#ifdef USE_SOLARIS
#undef map
#endif

#include <sys/ioctl.h>

#ifndef	HAVE_STRUCT_SOCKADDR_SA_LEN
	#undef HAVE_GETNAMEINFO
	#undef HAVE_GETIFADDRS
#endif

#if defined(HAVE_GETNAMEINFO) && defined(HAVE_GETIFADDRS)
	#include <ifaddrs.h>
	#include <netdb.h>

	QString flags_tos (unsigned int flags);
#endif

//EthernetDev *EthernetDev::ethernetdev = 0;
    QCString ethDevice;
    extern NetworkDev* networkdev;
    extern EthernetScan* ethernetscan;
    QTextStream ts;
    QString str;
    int value; 
    QString hexstring = QString::number(value, 16);   
   
   
struct MyNIC
{
   QString name;
   QString addr;
   QString netmask;
   QString state;
   QString type;
   QString hardware;
//   QString str;

   int hdw;
   int mtu;
};

typedef QPtrList<MyNIC> NicList;
QStringList ethlistcard;

NicList* findNics();

EthernetScan::EthernetScan(QWidget *parent, const char *name, const QStringList &)
 : ethernetWidget(parent, name)
{
connect( IPLineEdit, SIGNAL( returnPressed() ), this, SLOT(IPEntered() ) );
connect( netmaskLineEdit, SIGNAL( returnPressed() ), this, SLOT(netmaskEntered() ) );
connect( broadcastLineEdit, SIGNAL( returnPressed() ), this, SLOT(broadcastEntered() ) );
pixmapLabel1->setPixmap(DesktopIcon( "kcmpci"));

//netmaskEntered();
//ethernetDetails();
//netmaskEntered(ethlistcard);
}			 


EthernetScan::~EthernetScan()
{
}

void EthernetScan::IPEntered()
{
// First we check the validity of the IP address
}

QStringList EthernetScan::netmaskEntered()

{
	FILE* fp = fopen("/proc/net/dev", "r");

	QStringList list;

	if (!fp)
		return list;
	char interface[8];
	char buffer[128];

	// Ignore header...
	fgets(buffer, sizeof(buffer), fp);
	fgets(buffer, sizeof(buffer), fp);
	while(fgets(buffer, sizeof(buffer), fp))
	{
		sscanf(buffer, " %[^ \t\r\n:]", interface);
		list.append(interface);
	}

	return list;
}
//ethernetDetails();
//QStringList major = ethlist;
//KMessageBox::information(this, i18n("Testing this"));



void EthernetScan::broadcastEntered()
{
}

void EthernetScan::ethernetDetails(const QString &b)
{
    ethDevice = b;
    NicList *nics=findNics();    
    nics->setAutoDelete(true); 
    for (MyNIC* tmp=nics->first(); tmp!=0; tmp=nics->next())
//    ethlistcard.append(tmp->name);
    
     if ((tmp->name)== b) {
       textLabel2->setText( i18n( "<font size=\"+1\">%1 Configuration</font>" ).arg(b) );       
//       kIntNumInput1->setValue(tmp->mtu);

int number;
number = tmp->mtu;
       kIntNumInput1->setValue(tmp->mtu);
//       kIntNumInput1->setValue( 1492 );
       IPLineEdit->setText(tmp->addr);
       netmaskLineEdit->setText(tmp->netmask);
       broadcastLineEdit->setText(tmp->type);
       kListView->clear();
        new QListViewItem( kListView, "Hardware Address", tmp->hardware);       
	new QListViewItem( kListView, "Device Status", tmp->state);
//	new QListViewItem( kListView, "MTU Value", number);   
       }   
    
         delete nics;       

}

NicList* findNics()
{
   QString upMessage(   i18n("State of network card is connected",    "Up") );
   QString downMessage( i18n("State of network card is disconnected", "Down") );
   QStringList ethcardslist;
   NicList* nl=new NicList;
   nl->setAutoDelete(true);

#if !defined(HAVE_GETIFADDRS) || !defined(HAVE_GETNAMEINFO)

   int sockfd = socket(AF_INET, SOCK_DGRAM, 0);

   char buf[8*1024];
   struct ifconf ifc;
   ifc.ifc_len = sizeof(buf);
   ifc.ifc_req = (struct ifreq *) buf;
   int result=ioctl(sockfd, SIOCGIFCONF, &ifc);
   
   for (char* ptr = buf; ptr < buf + ifc.ifc_len; )
   {
      struct ifreq *ifr =(struct ifreq *) ptr;
      int len = sizeof(struct sockaddr);
#ifdef	HAVE_STRUCT_SOCKADDR_SA_LEN
      if (ifr->ifr_addr.sa_len > len)
         len = ifr->ifr_addr.sa_len;		/* length > 16 */
#endif
      ptr += sizeof(ifr->ifr_name) + len;	/* for next one in buffer */

      int flags;
      struct sockaddr_in *sinptr;
      MyNIC *tmp=0;
         tmp=new MyNIC;
         tmp->name=ifr->ifr_name;  
	 ethcardslist.append(tmp->name);   
      switch (ifr->ifr_addr.sa_family)
      {
      case AF_INET:
         sinptr = (struct sockaddr_in *) &ifr->ifr_addr; 

         flags=0;

         struct ifreq ifcopy;
         ifcopy=*ifr;
         result=ioctl(sockfd,SIOCGIFFLAGS, &ifcopy);

         flags=ifcopy.ifr_flags;

         tmp->state= ((flags & IFF_UP) == IFF_UP) ? upMessage : downMessage;


         tmp->addr=inet_ntoa(sinptr->sin_addr);

	ifcopy=*ifr;
	result=ioctl(sockfd, SIOCGIFNETMASK, &ifcopy);

	if (result==0)
	{
	   sinptr = (struct sockaddr_in *) &ifcopy.ifr_addr;
	   tmp->netmask=inet_ntoa(sinptr->sin_addr);	

	      
 	int type=ioctl(sockfd, SIOCGIFBRDADDR, &ifcopy);  	  
	if (type==0)
	tmp->type=inet_ntoa(sinptr->sin_addr);	

//	int hdw=ioctl(sockfd, SIOCGIFHWADDR, &ifcopy);  	  
//	if (hdw==0)
//	tmp->hdw=ioctl(sockfd, SIOCGIFHWADDR, &ifcopy); 
	
 //       int mtu=ioctl(sockfd, SIOCGIFMTU, &ifcopy);
//	if (mtu!=0)
//	tmp->mtu=ioctl(sockfd, SIOCGIFMTU, &ifcopy);	

//const char if_name[] = "eth1";
QString if_name = ethDevice;
#define STORED_USERNAME_KEY "Username"
 struct ifreq ifr;
 int fd;
 
 fd = socket(PF_INET, SOCK_DGRAM, IPPROTO_IP);
 
 strcpy(ifr.ifr_name, if_name);
 ioctl(fd, SIOCGIFMTU, &ifr);
 
 tmp->mtu=ifr.ifr_mtu;

     int sd, i;
    struct ifreq buff;

    sd = socket(PF_INET,SOCK_DGRAM,0);
    strncpy(buff.ifr_name, if_name, IFNAMSIZ);
    ioctl(sd,SIOCGIFHWADDR,&buff);

//    QTextStream::setf(8);    
    QTextStream ts( &str, IO_ReadWrite );
//    ts->setf(8);
 //   ts->setf(8);   

    for (i=0; i < 6; i++){

    value = (unsigned char)buff.ifr_hwaddr.sa_data[i];
    
    QString hexstring = QString::number(value, 16);   
    if(hexstring=="0")
       hexstring = "00";
    hexstring = hexstring.upper();
    ts <<  hexstring << ":" ;   
 
 }  
    tmp->hardware=str;
    
//    tmp->hdw=text;
 
        // str == "Decimal 63 is 3f in hexadecimal"
 
 //struct ifreq req;
// int hdwa;
// hdwa = socket(PF_INET, SOCK_DGRAM, IPPROTO_IP);
// strcpy(req.ifr_name, if_name);
// ioctl(hdwa, SIOCGIFHWADDR,&req);
// tmp->hdw=req.ifr_hwaddr.sa_data;
	
//	int mtuv=inet_ntoa(SIOCGIFMTU);	
//	QString mtuvalue="%1".arg(mtu);
	
	}
	else
	   tmp->netmask-i18n(" NO Value");	
	nl->append(tmp);
	break;
	
	default:
	   break;
	}
   
   }
#else
  struct ifaddrs *ifap, *ifa;
  if (getifaddrs(&ifap) != 0) {
    return nl;
  }

  MyNIC *tmp=0;
  for (ifa = ifap; ifa; ifa = ifa->ifa_next) {
    switch (ifa->ifa_addr->sa_family) {
    case AF_INET6:
    case AF_INET: {
      tmp = new MyNIC;
      tmp->name = ifa->ifa_name;

      char buf[128];

      bzero(buf, 128);
      getnameinfo(ifa->ifa_addr, ifa->ifa_addr->sa_len, buf, 127, 0, 0, NI_NUMERICHOST);
      tmp->addr = buf;

      if (ifa->ifa_netmask != NULL) {
	bzero(buf, 128);
	getnameinfo(ifa->ifa_netmask, ifa->ifa_netmask->sa_len, buf, 127, 0, 0, NI_NUMERICHOST);
	tmp->netmask = buf;
      }

      tmp->state= (ifa->ifa_flags & IFF_UP) ? upMessage : downMessage;
      tmp->type = flags_tos(ifa->ifa_flags);
//      tmp->type = ifr->ifr_broadaddr);
      nl->append(tmp);
      break;
    }
    default:
      break;
    }
  }

  freeifaddrs(ifap);
#endif
   return nl;
}

#if defined(HAVE_GETNAMEINFO) && defined(HAVE_GETIFADDRS)
QString flags_tos (unsigned int flags)
{
  QString tmp;
  if (flags & IFF_POINTOPOINT) {
    tmp +=  i18n("Point to Point");
  }

  if (flags & IFF_BROADCAST) {
    if (tmp.length()) {
      tmp += QString::fromLatin1(", ");
    }
    tmp += i18n("Value");
  }
  
  if (flags & IFF_MULTICAST) {
    if (tmp.length()) {
      tmp += QString::fromLatin1(", ");
    }
    tmp += i18n("Multicast");
  }1039541
  
  if (flags & IFF_LOOPBACK) {
    if (tmp.length()) {
      tmp += QString::fromLatin1(", ");
    }
    tmp += i18n("Loopback");
  }
  return tmp;
}
#endif
