#include "setupdlg.h"
#include "fontsetup.h"
#include "fontsetup.h"
#include "timersetup.h"
#include "../stringres.h"
#include <kapp.h>
#include <qspinbox.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include "settings.h"

#define Inherited CSetupDlgData

CSetupDlg::CSetupDlg(QWidget* parent,const char* name)
    :Inherited( parent, name,true )
{
    m_FixedFont = GlobalSettings.get_fixed_font();
    m_NonPropFont = GlobalSettings.get_nonprop_font();
    m_StatusTime = GlobalSettings.StatusPolltime();
    m_ThreadTime = GlobalSettings.ThreadPolltime();
    m_ThreadTimeoutEdit->setValue(m_ThreadTime);
    m_StatusTimeoutEdit->setValue(m_StatusTime);
    m_Blobwidth = m_Blobheight = 30;
    int w,h;
    GlobalSettings.getBlobimages(m_Blobimage,m_Blobscale,w,h);
    m_Imagewidth->setValue(w);
    m_Imageheight->setValue(h);
    m_Imageunscaled->setChecked(!m_Blobscale);
    m_Imagescale->setChecked(m_Blobscale);
    m_BlobasImage->setChecked(m_Blobimage);
    m_DispRealMultiline->setChecked(GlobalSettings.getRealmultilines());
    m_compactLayoutButton->setChecked(GlobalSettings.getCompactLayout());
    m_OldtableBrowser->setChecked(GlobalSettings.getOldBrowser());
}

CSetupDlg::~CSetupDlg()
{
}

const QFont& CSetupDlg::fixed_font()const{return m_FixedFont;}
const QFont& CSetupDlg::nonprop_font()const{return m_NonPropFont;}

int CSetupDlg::ThreadPolltime()const
{
    return m_ThreadTime;
}

int CSetupDlg::StatusPolltime()const
{
    return m_StatusTime;
}
/** No descriptions */
void CSetupDlg::accept()
{
    CSetupDlgData::accept();
}

void CSetupDlg::statusTime(int time)
{
    m_StatusTime = time;
}

void CSetupDlg::threadTime(int time)
{
    m_ThreadTime = time;
}

int CSetupDlg::exec()
{
    return CSetupDlgData::exec();
}

void CSetupDlg::fixFontChanged(const QFont&aFont)
{
    m_FixedFont = aFont;
}

void CSetupDlg::compactLayoutToggled( bool how)
{
    m_compactLayout = how;
}

bool CSetupDlg::compactLayout()const
{
    return m_compactLayout;
}

void CSetupDlg::oldBrowserToggled(bool how)
{
    m_oldBrowser = how;
}

bool CSetupDlg::oldBrowser()const
{
    return m_oldBrowser;
}

void CSetupDlg::nonpropFontChanged(const QFont&aFont)
{
    m_NonPropFont = aFont;
}

void CSetupDlg::blobasImage(bool how)
{
    m_Imageunscaled->setEnabled(how);
    m_Imagescale->setEnabled(how);
    m_Imagewidth->setEnabled(how&&m_Imagescale->isChecked());
    m_Imageheight->setEnabled(how&&m_Imagescale->isChecked());
    m_Blobimage = how;
}

void CSetupDlg::imageUnscaled(bool)
{
}

void CSetupDlg::imageScaled(bool how)
{
    m_Imagewidth->setEnabled(how);
    m_Imageheight->setEnabled(how);
    m_Blobscale = how;
}

void CSetupDlg::imageHeight(int value)
{
    m_Blobheight = value;
}

void CSetupDlg::imageWidth(int value)
{
    m_Blobwidth = value;
}

bool CSetupDlg::Blobimage()const
{
    return m_Blobimage;
}
bool CSetupDlg::Blobscale()const
{
    return m_Blobscale;
}
int CSetupDlg::Blobwidth()const
{
    return m_Blobwidth;
}
int CSetupDlg::Blobheight()const
{
    return m_Blobheight;
}

void CSetupDlg::dispRealMultiline(bool how)
{
    m_Dispmulti = how;
}
bool CSetupDlg::dispMultiline()const
{
    return m_Dispmulti;
}
