#include <qstring.h>
#include <string.h>

#ifndef QT_STL_STRING_H
#define QT_STL_STRING_H

class QTextCodec;

class QtStlString
{
protected:
    QTextCodec*m_Usecodec;
public:
    QtStlString();
    virtual ~QtStlString();
    QString stl2qt(const std::string&input)const;
    std::string qt2stl(const QString&input)const;
};

extern QtStlString GlobalStringTrans;

#define STL_TO_QT_STRING(x) (GlobalStringTrans.stl2qt(x))
#define QT_TO_STL_STRING(x) (GlobalStringTrans.qt2stl(x))

#endif
