//
// C++ Implementation: profiles_input
//
// Description:
//
//
// Author: Rajko Albrecht <ral@alwins-world.de>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "profiles_input.h"
#include <klineedit.h>
#include <qpushbutton.h>
#include "kmysqladmin/setup/settings_defines.h"

CProfilesInput::CProfilesInput(const QStringList&current_names, QWidget *parent, const char *name)
 : CProfilesInputData(parent, name),m_currentNames(current_names),m_ChangeName(""),m_NameOk(false),m_PassOk(true)
{
    m_Values[Settings_defines::_PROFILES_host]="";
    m_Values[Settings_defines::_PROFILES_user]="";
    m_Values[Settings_defines::_PROFILES_port]="3306";
    m_Values[Settings_defines::_PROFILES_pass]="";
    m_Values[Settings_defines::_PROFILES_pass]="";
    m_Values[Settings_defines::_PROFILES_name]="";
    PortEdit->setText("3306");
    checkOk();
}

CProfilesInput::CProfilesInput(const QMap<QString,QString>&aValues,const QStringList&current_names,QWidget *parent, const char *name)
 : CProfilesInputData(parent, name),m_currentNames(current_names),m_NameOk(false),m_PassOk(true)
{
    m_Values = aValues;
    UserEdit->setText(m_Values[Settings_defines::_PROFILES_user]);
    HostEdit->setText(m_Values[Settings_defines::_PROFILES_host]);
    PortEdit->setText(m_Values[Settings_defines::_PROFILES_port]);
    HostEdit->setText(m_Values[Settings_defines::_PROFILES_host]);
    PassEdit->setText(m_Values[Settings_defines::_PROFILES_pass]);
    m_ReenterPass->setText(m_Values[Settings_defines::_PROFILES_pass]);
    m_ChangeName = m_Values[Settings_defines::_PROFILES_name];
    m_NameInput->setText(m_Values[Settings_defines::_PROFILES_name]);
}

CProfilesInput::~CProfilesInput()
{
}

const QMap<QString,QString>&CProfilesInput::values()const
{
    return m_Values;
}

void CProfilesInput::focus_user()
{
    UserEdit->setFocus();
}
void CProfilesInput::focus_password()
{
    PassEdit->setFocus();
}
void CProfilesInput::focus_password2()
{
    m_ReenterPass->setFocus();
}
void CProfilesInput::focus_port()
{
    PortEdit->setFocus();
}
void CProfilesInput::focus_ok()
{
    OkButton->setFocus();
}
void CProfilesInput::focus_host()
{
    HostEdit->setFocus();
}

void CProfilesInput::keyPressEvent(QKeyEvent*e)
{
    if (e->key() == Key_Return && (OkButton->hasFocus()) ) {
        e->accept();
        OkButton->animateClick();
        return;
    }
    if (e->key()==Key_Escape) {
        e->accept();
        reject();
    }
    if (e->isAccepted())
        return;
    CProfilesInputData::keyPressEvent(e);
}

void CProfilesInput::nameChange(const QString&aText)
{
    m_NameOk = (aText.length()>0 &&
        aText.length()<=25 &&
        (m_currentNames.find(aText) == m_currentNames.end()||aText==m_ChangeName));
    checkOk();
}

void CProfilesInput::passChange(const QString&)
{
    m_PassOk = (m_ReenterPass->text()==PassEdit->text());
    checkOk();
}

void CProfilesInput::checkOk()
{
    OkButton->setEnabled(m_PassOk&&m_NameOk);
}

void CProfilesInput::accept()
{
    m_Values[Settings_defines::_PROFILES_host]=HostEdit->text();
    m_Values[Settings_defines::_PROFILES_user]=UserEdit->text();
    m_Values[Settings_defines::_PROFILES_port]=PortEdit->text();
    m_Values[Settings_defines::_PROFILES_pass]=m_ReenterPass->text();
    m_Values[Settings_defines::_PROFILES_name]=m_NameInput->text();
    CProfilesInputData::accept();
}
