/***************************************************************************
                          changemysqluser.cpp  -  description
                             -------------------
    begin                : Son Nov 16 2003
    copyright            : (C) 2003 by Rajko Albrecht
    email                : ral@alwins-world.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "changemysqluser.h"
#include <klineedit.h>
#include <klistbox.h>
#include <qcheckbox.h>
#include <klocale.h>
#include <kcombobox.h>
#include <iostream>
#include <qspinbox.h>
#include "kmysqladmin/helpers/qt_stl_string.h"
#include "kmysqladmin/helpers/stringhelper.h"

using namespace std;

CChangemysqluser::CChangemysqluser(const std::string& user, const std::string& host, const std::string& pw,
                                    const std::string&db,const std::string&table,const std::string&column,
                                    const stringlist&current_rights, bool had_grant,
                                    smart_pointer<CMySql>& _sql_server,QWidget *parent, const char *name )
    : CAddmysqluser(_sql_server,parent,name)
{
    npw = pw;
    npw2 = pw;
    usernameinput->setText(STL_TO_QT_STRING(user));
    usernameinput->setReadOnly(true);
    hostnameedit->setText(STL_TO_QT_STRING(host));
    hostnameedit->setReadOnly(true);
    pw1input->setText(STL_TO_QT_STRING(pw));
    pw2input->setText(STL_TO_QT_STRING(pw));
    bool no_first_page = false;
    if (Caseequ()(db,"*")==0) {
        pw1input->setReadOnly(true);
        pw2input->setReadOnly(true);
        no_first_page = true;
    }
    m_current_db = db;
    m_current_table = table;
    dbinput->setText(STL_TO_QT_STRING(db));
    tableinput->setText(STL_TO_QT_STRING(table));
    QListBoxItem*item = 0;
    if (column.size()) {
        enable_column_check->setChecked(true);
        for (int j=0;j<column_list->count();++j) {
            if (Caseequ()(column,QT_TO_STL_STRING(column_list->text(j)))) {
                column_list->setCurrentItem(j);
                break;
            }
        }
    }

    if (current_rights.size()) {
        stringlist::const_iterator it = current_rights.begin();

        for (;it!=current_rights.end();++it) {
            if (Caseequ()(*it,"Grant") == 1) {
                enablegrantbox->setChecked(true);
                continue;
            }
            item = rights_list->findItem(STL_TO_QT_STRING(*it));
            if (item) {
                rights_list->setSelected(item,true);
            } else {
                cout << *it << " not found " << endl;
            }
        }
    } else if (!had_grant) {
        check_usage->setChecked(true);
    }
    if (had_grant) {
        enablegrantbox->setChecked(true);
    }
    enable_column_check->setEnabled(false);
    column_list->setEnabled(false);
    removePage(page_2);
    if (no_first_page) {
        removePage(page);
    }
    QString s = i18n("Modifying rights for user %1@%2 on %3.%4");
    s = s.arg(STL_TO_QT_STRING(user)).arg(STL_TO_QT_STRING(host)).arg(STL_TO_QT_STRING(db)).arg(STL_TO_QT_STRING(table));
    setCaption(s);
}

CChangemysqluser::~CChangemysqluser()
{
}

void CChangemysqluser::accept()
{
    npw = QT_TO_STL_STRING(pw1input->text());
    CAddmysqluserdata::accept();
}

void CChangemysqluser::setMaxConnections(const int t)
{
    m_ConnectionsHour->setValue(t);
}

void CChangemysqluser::setMaxUpdates(const int t)
{
    m_UpdatesHour->setValue(t);
}

void CChangemysqluser::setMaxQueries(const int t)
{
    m_QueriesHour->setValue(t);
}
