// -*- Mode: C++; -*-
/***************************************************************************
                          addmysqluser.h  -  description
                             -------------------
    begin                : Sam Sep 27 2003
    copyright            : (C) 2003 by Rajko Albrecht
    email                : ral@alwins-world.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ADDMYSQLUSER_H
#define ADDMYSQLUSER_H

#include <qwidget.h>
#include <qstring.h>
#include <qstringlist.h>
#include <addmysqluserdata.h>
#include "kmysqladmin/backend/my_sql/my_sql.h"
#include <map>

/**
  *@author Rajko Albrecht
  */
class CAddmysqluser : public CAddmysqluserdata  {
    Q_OBJECT

protected:
    smart_pointer<CMySql> sql_server;
    std::string npw,npw2,hostname,username;
    std::map<std::string,stringlist> m_db_tables;
    stringlist m_columns_list;
    stringlist m_db_list;
    stringlist m_rights_list;
    std::string m_current_db;
    std::string m_current_table;
    bool m_grant;

    QStringList hostrights,userrights,dbrights,tablerights,columnrights;

public:
    CAddmysqluser(smart_pointer<CMySql>& _sql_server,QWidget *parent=0, const char *name=0);
    ~CAddmysqluser();
    const std::string&user()const{return username;}
    const std::string&host()const{return hostname;}
    const std::string&password()const{return npw;}
    const std::string&database()const{return m_current_db;}
    const std::string&table()const{return m_current_table;}
    const stringlist&set_rights()const{return m_rights_list;}
    const bool grant()const{return m_grant;}
    int maxQueries()const;
    int maxUpdates()const;
    int maxConnections()const;

    static const std::string JOKER;
    static const char*GRANT;
    static const char*ALL;

protected:
    void check_next_1();
    void init_right_lists();
    void check_buttons();
    virtual void check_finish();

protected slots:
    virtual void pw1changed(const QString&);
    virtual void pw2changed(const QString&);
    virtual void dblistchanged(const QString&);
    virtual void alternate_db_changed(bool);
    virtual void dbtext_changed(const QString&);
    virtual void tablelistchanged(const QString&);
    virtual void alternate_table_changed(bool);
    virtual void tabletext_changed(const QString&);
    virtual void hostname_changed(const QString&);
    virtual void username_changed(const QString&);
    virtual void column_check_changed(bool);
    virtual void column_list_changed(const QString&);
    virtual void enable_grants_changed(bool);
    virtual void allrightsbox_changed(bool);
    virtual void usage_toggled(bool);
    virtual void rights_selection_changed();
    virtual void accept();
};

#endif
