/***************************************************************************
                          addmysqlhost.cpp  -  description
                             -------------------
    begin                : Mon Sep 29 2003
    copyright            : (C) 2003 by Rajko Albrecht
    email                : ral@alwins-world.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "addmysqlhost.h"
#include "kmysqladmin/backend/my_sql/my_sql.h"
#include "kmysqladmin/helpers/qt_stl_string.h"

#include <klistbox.h>
#include <kpushbutton.h>
#include <qcheckbox.h>
#include <klineedit.h>
#include <iostream>

using namespace std;

CAddmysqlhost::CAddmysqlhost(smart_pointer<CMySql>& _sql_server,QWidget *parent, const char *name )
    : CAddmysqlhostdata(parent,name)
{
    sql_server = _sql_server;
    init_all();
}

CAddmysqlhost::CAddmysqlhost(smart_pointer<CMySql>& _sql_server,const std::string&aHost, const std::string& aDb, const stringlist&aRights, bool aGrant, QWidget *parent, const char *name)
    : CAddmysqlhostdata(parent,name)
{
    sql_server = _sql_server;
    // we'll a modify dialog instead of a add dialog
    init_all();
    dbinput->setText(STL_TO_QT_STRING(aDb));
    hnameinput->setText(STL_TO_QT_STRING(aHost));
    dbinput->setReadOnly(true);
    hnameinput->setReadOnly(true);
    string d;
    for (unsigned int c=0; c < rights_box->count();++c) {
        d =QT_TO_STL_STRING(rights_box->text(c));
        if (std::find_if(aRights.begin(),aRights.end(),Caseequif(d))!=aRights.end()) {
            rights_box->setSelected(c,true);
        }
    }
    if (aGrant) {
        m_grant = true;
        grant_button->setChecked(true);
    }
}

void CAddmysqlhost::init_all()
{
    init_list();
    ok_button->setEnabled(false);
    m_grant =false;
    m_all_rights = false;
    m_right_set = false;
}

CAddmysqlhost::~CAddmysqlhost()
{
}

void CAddmysqlhost::all_rights_changed(bool how)
{
    m_all_rights = how;
    rights_box->setEnabled(!how);
    if (!how) {
        rights_selection_changed();
    } else {
        m_right_set = true;
    }
    check_ok();
}

void CAddmysqlhost::grant_changed(bool how)
{
    m_grant = how;
    check_ok();
}

void CAddmysqlhost::rights_selection_changed()
{
    m_right_set = false;
    for (unsigned c = 0; c < rights_box->count();++c) {
        if (rights_box->isSelected(c)) {
            m_right_set = true;
            break;
        }
    }
    check_ok();
}

void CAddmysqlhost::hname_changed(const QString&)
{
    check_ok();
}

void CAddmysqlhost::db_name_changed(const QString&)
{
    check_ok();
}

void CAddmysqlhost::init_list()
{
    const char**rights = sql_server->host_rights();
    for (unsigned i = 0; rights[i]!=0;++i) {
        if (Caseequ()(rights[i],"grant"))
            continue;
        rights_box->insertItem(rights[i]);
    }
}

void CAddmysqlhost::check_ok()
{
    if (dbinput->text().length()==0 || hnameinput->text().length()==0 ||
        (!m_right_set && !m_grant)) {
        ok_button->setEnabled(false);
    } else {
        ok_button->setEnabled(true);
    }
}

void CAddmysqlhost::accept()
{
    m_right_list.clear();
    for (unsigned c = 0; c < rights_box->count();++c) {
        if (m_all_rights || rights_box->isSelected(c)) {
            m_right_list.push_back(QT_TO_STL_STRING(rights_box->text(c)));
        }
    }
    if (m_grant) {
        m_right_list.push_back("Grant");
    }
    m_db = QT_TO_STL_STRING(dbinput->text());
    m_host = QT_TO_STL_STRING(hnameinput->text());
    CAddmysqlhostdata::accept();
}
