/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2004
*/
#ifndef KMFRULEEDITIP_H
#define KMFRULEEDITIP_H

#include "kmyfirewallruleeditorip.h"

// QT includes
#include <qvariant.h>
#include <qdialog.h>
#include <qptrlist.h>

namespace KMF {
class IPTRule;
class KMFErrorHandler;
class KMFCheckInput;
class KMFError;
class KMFRuleEditIP : public KMyFirewallRuleEditorIP /*, virtual public KMFRuleOptionEditInterface */{
	Q_OBJECT

public:
	KMFRuleEditIP( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~KMFRuleEditIP();

// 	QPtrList<QString>* options;

	void loadRule( IPTRule * );
public slots:
	void accept();
	void reject();
	void slotHelp();

protected:
	QVBoxLayout* KMyFirewallRuleEditorIPLayout;
	QGridLayout* Layout85;
	QGridLayout* GroupBox16Layout;
	QHBoxLayout* Layout50;
	bool event( QEvent* );

private:
	KMFCheckInput *m_CheckInput;
	KMFErrorHandler *m_ErrorHandler;
	IPTRule* m_rule;
	KMFError *m_err;

signals:
/*	void sigAddRuleOpt( QString*, QPtrList<QString>* );
	void sigDelRuleOpt( QString * );*/
	void sigDocumentChanged();
	void sigHideMe();
//	void sigAddUndo();
};
}






#endif // KMFRULEEDITIP_H
