//
// C++ Implementation: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfruleoptioneditinterface.h"


// QT includes
#include <qstring.h>

// KDE includes
#include <kdebug.h>
#include <klocale.h>

// Project includes
#include "../../core/iptrule.h"
#include "../../core/kmfruleeditinterface.h"
#include "kmfruleeditorinterface.h"

namespace KMF {
KMFRuleOptionEditorInterface::KMFRuleOptionEditorInterface(QObject *parent, const char *name)
		: KMFRuleOptionEditInterface(parent, name) {
	kdDebug() <<"KMFRuleOptionEditorInterface::KMFRuleOptionEditorInterface(QObject *parent, const char *name)" << endl;
	kdDebug() << "Parent has Type: " << parent->className()  << endl;
	
	m_edit = new KMFRuleEditorInterface( 0 , "Edit", 0 );
	m_edit->hide();

/*	connect( m_edit,SIGNAL(sigAddRuleOpt(QString*, QPtrList< QString >* ) ), 
		this,SLOT( slotAddRuleOption(QString*, QPtrList< QString >* ) ) );
	connect( m_edit,SIGNAL(sigAddTargetOpt(QString*, QPtrList< QString >* ) ), 
		this,SLOT( slotAddTargetOption(QString*, QPtrList< QString >* ) ) );*/
	connect( m_edit,SIGNAL(sigHideMe() ), 
		this,SLOT( slotShowOverview() ) );
}
KMFRuleOptionEditorInterface::~KMFRuleOptionEditorInterface() {}

void KMFRuleOptionEditorInterface::slotShowOverview() {
	if ( KMFRuleEditInterface* ruleedit = dynamic_cast<KMFRuleEditInterface*> ( parent() ) ) {
		ruleedit->showOverview();
	} else {
		kdDebug() << "KMFRuleOptionEditCustom::slotShowOverview(): parent() not of type KMFRuleEditInterface" << endl;
	}
}

const QString& KMFRuleOptionEditorInterface::optionEditName() const {
	return *( new QString( i18n("Interface Option") ) );
}
const QString& KMFRuleOptionEditorInterface::description() const {
	return *( new QString( i18n("This plugin manages the Interface based options of iptables.") ) );
}

void KMFRuleOptionEditorInterface::loadRule( IPTRule* rule ) {
	if ( !rule ) {
		kdDebug() << "KMFRuleOptionEditorInterface::loadRule( IPTRule* rule ) - rule == 0" << endl;
		return;
	}
	
	m_edit->loadRule( rule );
	m_rule = rule;

}

QWidget* KMFRuleOptionEditorInterface::editWidget() {
	if ( ! m_edit ) {
		kdDebug() << "KMFRuleOptionEditorInterface::editWidget() - m_edit == 0" << endl;
		return 0;
	}
	return m_edit;
}





// It's usually safe to leave the factory code alone.. with the
// notable exception of the KAboutData data
#include <kaboutdata.h>
#include <klocale.h>

// KInstance* KMFRuleOptionEditorInterfaceFactory::s_instance = 0L;
// KAboutData* KMFRuleOptionEditorInterfaceFactory::s_about = 0L;

KMFRuleOptionEditorInterfaceFactory::KMFRuleOptionEditorInterfaceFactory( QObject* parent, const char* name )
		: KLibFactory( parent, name ) {
// 	s_instance = new KInstance( "KMFRuleOptionEditorInterfaceFactory" );
}

QObject* KMFRuleOptionEditorInterfaceFactory::createObject( QObject* parent, const char* name,
        const char*, const QStringList & ) {
	QObject * obj = new KMFRuleOptionEditorInterface( parent, name );
	emit objectCreated( obj );
	return obj;
}


// KInstance* KMFRuleOptionEditorInterfaceFactory::instance() {
// 	if ( !s_instance ) {
// 		s_instance = new KInstance( "KMFRuleOptionEditorInterfaceFactory" );
// 	}
// 	return s_instance;
// }

extern "C" {
	void* init_libkmfruleoptionedit_interface() {
		return new KMFRuleOptionEditorInterfaceFactory;
	}
}

}


#include "kmfruleoptioneditinterface.moc"
