//
// C++ Implementation: kmfqtdesignerplugin
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfqtdesignerplugin.h"

// Qt includes


// Prokject includes
#include "kmfipv4addresswidget.h"
namespace KMF {
Q_EXPORT_PLUGIN( KMFQTDesignerPlugin )

KMFQTDesignerPlugin::KMFQTDesignerPlugin()
		: QWidgetPlugin() {}


KMFQTDesignerPlugin::~KMFQTDesignerPlugin() {}

QStringList KMFQTDesignerPlugin::keys() const {
	QStringList list;
	list << "KMFIPv4AddressWidget";
	return list;
}

QWidget* KMFQTDesignerPlugin::create ( const QString &key, QWidget* parent, const char* name ) {
	if ( key == "KMFIPv4AddressWidget" )
		return new KMFIPv4AddressWidget ( parent, name );
	return 0;
}


QString KMFQTDesignerPlugin::group ( const QString& feature ) const {
	if ( feature == "KMFIPv4AddressWidget" )
		return "Input";
	return QString::null;
}

QIconSet KMFQTDesignerPlugin::iconSet ( const QString& ) const {
	return QIconSet ( QPixmap ( "filechooser_pixmap" ) );
}

QString KMFQTDesignerPlugin::includeFile ( const QString& feature ) const {
	if ( feature == "KMFIPv4AddressWidget" )
		return "kmfipv4addresswidget.h";
	return QString::null;
}

QString KMFQTDesignerPlugin::toolTip ( const QString& feature ) const {
	if ( feature == "KMFIPv4AddressWidget" )
		return "File Chooser Widget";
	return QString::null;
}

QString KMFQTDesignerPlugin::whatsThis ( const QString& feature ) const {
	if ( feature == "KMFIPv4AddressWidget" )
		return "A widget to change an IPv4 Address";
	return QString::null;
}

bool KMFQTDesignerPlugin::isContainer ( const QString& ) const {
	return FALSE;
}

}
