//
// C++ Interface:
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef KMFPROTOCOLPROPERTIESWIDGET_H
#define KMFPROTOCOLPROPERTIESWIDGET_H

#include "kmyfirewallprotocolpropertieswidget.h"


#include <qptrlist.h>
#include <qstring.h>
#include <qguardedptr.h>
#include <qpixmap.h>
#include <quuid.h>

namespace KMF {
class KMFProtocol;
class KMFProtocolUsage;
class KMFProtocolCategory;

class KMFProtocolPropertiesWidget : public KMyFirewallProtocolPropertiesWidget {
		Q_OBJECT

	public:
		KMFProtocolPropertiesWidget ( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
		~KMFProtocolPropertiesWidget();
		/*$PUBLIC_FUNCTIONS$*/
		
		void loadProtocolUsage( KMFProtocolUsage* );
		void loadProtocol( KMFProtocol* );
		void loadProtocolCategory( KMFProtocolCategory* );
		
	public slots:
		/*$PUBLIC_SLOTS$*/

	protected:
		/*$PROTECTED_FUNCTIONS$*/
		void blockAllSignals( bool );
		
	protected slots:
		/*$PROTECTED_SLOTS$*/
	void slotEnableProtocolLimit( bool );
	void slotSetProtocolLimitRate( int );
	void slotSetProtocolLimitInterval( const QString& );
	void slotEnableProtocolLogging( bool );
	void slotProtocolDeleted();

	private:
		QGuardedPtr<KMFProtocolUsage> m_protocolUsage;
		// QGuardedPtr<KMFProtocolUsage> m_protocol;
};
}
#endif

