//
// C++ Implementation:
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include "kmfipv4addresswidget.h"

// QT includes
#include <qlistview.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qwidgetstack.h>
#include <qtextedit.h>
#include <qtimer.h>


// KDE includes
#include <kdebug.h>
#include <klocale.h>
#include <klistview.h>
#include <kcombobox.h>
#include <kpopupmenu.h>
#include <kiconloader.h>
#include <kinputdialog.h>
#include <knuminput.h>

// Project includes
#include "../core/ipaddress.h"
namespace KMF {
KMFIPv4AddressWidget::KMFIPv4AddressWidget ( QWidget* parent, const char* name, WFlags fl )
		: KMyFirewallIPv4AdddressWidget ( parent,name,fl ) {
		
//	m_address = new IPAddress( 0,0,0,0 );	
	connect( m_sb_from_1, SIGNAL( valueChanged( const QString& ) ),
		this, SLOT( slotAddressChanged( const QString& ) ) );
	connect( m_sb_from_2, SIGNAL( valueChanged( const QString& ) ),
		this, SLOT( slotAddressChanged( const QString& ) ) );
	connect( m_sb_from_3, SIGNAL( valueChanged( const QString& ) ),
		this, SLOT( slotAddressChanged( const QString& ) ) );
	connect( m_sb_from_4, SIGNAL( valueChanged( const QString& ) ),
		this, SLOT( slotAddressChanged( const QString& ) ) );		
}

KMFIPv4AddressWidget::~KMFIPv4AddressWidget() {}

/*$SPECIALIZATION$*/

void KMFIPv4AddressWidget::loadIPAddress( int d0, int d1, int d2, int d3 ) {
	kdDebug() << "KMFIPv4AddressWidget::loadIPAddress( " 
		<< d0 << "." 
		<< d1 << "." 
		<< d2 << "."
		<< d3 << " )" << endl;
	
	
	
	m_sb_from_1->blockSignals( true );
	m_sb_from_2->blockSignals( true );
	m_sb_from_3->blockSignals( true );
	m_sb_from_4->blockSignals( true );
	
	m_sb_from_1->setValue( d0 );
	m_sb_from_2->setValue( d1 );
	m_sb_from_3->setValue( d2 );
	m_sb_from_4->setValue( d3 );

	m_sb_from_1->blockSignals( false );
	m_sb_from_2->blockSignals( false );
	m_sb_from_3->blockSignals( false );
	m_sb_from_4->blockSignals( false );
	
	m_sb_from_1->setEnabled( true );
	m_sb_from_2->setEnabled( true );
	m_sb_from_3->setEnabled( true );
	m_sb_from_4->setEnabled( true );
	
	// m_address->setAddress( d0, d1, d2, d3 );
}

void KMFIPv4AddressWidget::slotAddressChanged( const QString& ) {
	kdDebug() << "KMFIPv4AddressWidget::slotAddressChanged( const QString& )" << endl;
	/*
	if ( ! m_address ) {
		return;
	}
	
	const QString& newAddr =  m_sb_from_1->text() +"."+
														m_sb_from_2->text() +"."+
														m_sb_from_3->text() +"."+
														m_sb_from_4->text();
	if ( m_address->toString() == newAddr ) {
		return;
	}*/
	
	emit sigAddressChanged( 
		m_sb_from_1->value(),
		m_sb_from_2->value(), 
		m_sb_from_3->value(), 
		m_sb_from_4->value() );
}

}

#include "kmfipv4addresswidget.moc"

