/***************************************************************************
 begin                : Mon Jan 28 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KMFPFINSTALLER_H
#define KMFPFINSTALLER_H
#include <qobject.h>
#include <qpixmap.h>
#include <qstringlist.h>

#include <kparts/part.h>
#include <kparts/plugin.h>
#include <kparts/factory.h>
#include <kxmlgui.h>



#include "../../core/kmfplugin.h"
#include "../../core/kmfinstallerinterface.h"

#include "../../kmyfirewall.h"

class QString;
class QLabel;
class QPushButton;
class QGridLayout;
class KTempFile;
class KInstance;


namespace KMF {

class KMFProcOut;
class KMFError;
class KMFTarget;
class KMFErrorHandler;
class KMFCompilerInterface;

class KMFPFInstaller :  public KMFPlugin, public KMFInstallerInterface {
	Q_OBJECT

public:
	KMFPFInstaller( QObject* parent = 0, const char* name = 0 );
	~KMFPFInstaller();
	virtual KMFCompilerInterface* compiler();
 	virtual void cmdRunFW();
 	virtual void cmdStopFW();
 	virtual void cmdInstallFW();
 	virtual void cmdUninstallFW();
 	virtual void cmdShowRunningConfig( const QString& );
 	virtual void generateInstallerPackage( KMFTarget*, const KURL& );
 	virtual const QString& osName() const {
		return m_osName;
	}
	virtual const QString& osGUIName() const {
		return m_osGUIName;
	}
 	virtual QValueList<KMFCompilerInterface*>* compilers();
 	
 	

public slots:


private:    // functions
	QString m_osName;
	QString m_osGUIName;
	KMFProcOut* execWidget();

/*	void loadIcons();
	
	KMFError* createInitScript( const QString& file, const QString& systemtype );

	
	QString cmdShowAll();
	QString cmdShowFilter();
	QString cmdShowNat();
	QString cmdShowMangle();
	void installRemote();
	
	
	void parseFileHeaders( const QString& source_file_path, const QString& target_file_path ); 
	void writeBase64DataField( const QString& source_file_path, const QString& target_file_path, const QString& data );*/
	
	
private:
	KMFProcOut *m_execWidget;
	QString m_script;
	
};




class KMFPFInstallerFactory : public KLibFactory {
	Q_OBJECT
public:
	KMFPFInstallerFactory( QObject *parent = 0, const char *name = 0 );
	virtual ~KMFPFInstallerFactory() {};
	virtual QObject* createObject( QObject* parent = 0, const char* pname = 0,
	                               const char* name = "QObject",
	                               const QStringList &args = QStringList() );
};
}

#endif // KMFPFINSTALLER_H
