/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001
*/


#ifndef __kmfgenericinterface_part_h__
#define __kmfgenericinterface_part_h__

#include <klibloader.h>
#include <kparts/part.h>
#include <kparts/factory.h>

class KInstance;
class KAboutData;
class QLabel;
class KAction;
class KActionMenu;

namespace KMF {
class KMFMainWindow;
class KMFGenericInterface;

class KMFGenericInterfacePart: public KParts::ReadWritePart {
	Q_OBJECT
public:
	KMFGenericInterfacePart( QWidget *parent, const char *name, QObject *parentObject, const
                char *nameOb,
	                         const QStringList & /*args*/ );
	virtual ~KMFGenericInterfacePart();
	static KAboutData *createAboutData();

	/**
	 * This is a virtual function inherited from KParts::ReadWritePart.
	 * A shell will use this to inform this Part if it should act
	 * read-only
	 */
	virtual void setReadWrite( bool rw );

	/**
	 * Reimplemented to disable and enable Save action
	 */
	virtual void setModified( bool modified );
public slots:
	void slotEnableActions( bool );
	void slotGoAccessControl();
	void slotGoMyNetwork();
	void slotGoSpecialHosts();
	void slotGoICMPOptions();
	void slotGoNATConfiguration();
	void slotGoLogging();
	
	void slotTargetChanged();
	
	
	
	
protected:
	/**
	 * This must be implemented by each part
	 */
	virtual bool openFile();

	/**
	 * This must be implemented by each read-write part
	 */
	virtual bool saveFile();

private:
	KMFMainWindow *m_app;
	
	KMFGenericInterface *m_genericinterface;
	KAction* m_actionGoMyNetwork;
	KAction* m_actionGoAccessControl;
	KAction* m_actionGoSpecialHosts;
	KAction* m_actionGoICMPOptions;
	KAction* m_actionGoNATConfiguration;
	KAction* m_actionGoLogging;

/*signals:
	void sigUpdateView();*/
};



class KMFGenericInterfacePartFactory : public KParts::Factory
{
    Q_OBJECT
public:
    KMFGenericInterfacePartFactory();
    virtual ~KMFGenericInterfacePartFactory();
    virtual KParts::Part* createPartObject( QWidget *parentWidget, const char *widgetName,
                                            QObject *parent, const char *name,
                                            const char *classname, const QStringList &args );
    static KInstance* instance();

private:
    static KInstance* s_instance;
    static KAboutData* s_about;
};
}
#endif


