//
// C++ Implementation: kmfplugin
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfplugin.h"

// QT includes
#include <qwidget.h>

// KDE includes
#include <kapplication.h>
#include <kdebug.h>

// Project includes
#include "kmyfirewallinterface.h"
#include "kmfrulesetdoc.h"
#include "kmfnetwork.h"
#include "kmfgenericdoc.h"
#include "kmfiptdoc.h"
#include "kmfdoc.h"
#include "kmferror.h"

namespace KMF {

KMFPlugin::KMFPlugin( QObject* parent , const char* name ) : KParts::Plugin( parent , name ) {
	m_err = new KMFError();
}

KMFPlugin::~KMFPlugin() {
	kdDebug() << "Calling Destructor: KMFPlugin::~KMFPlugin()" << endl;
	delete m_err;
}

KMFNetwork* KMFPlugin::network() {
	return KMyFirewallInterface::instance()->network();
}

KMFDoc* KMFPlugin::doc() {
	return  KMyFirewallInterface::instance()->network()->currentDoc();
}

KMFGenericDoc* KMFPlugin::genericDoc() {
	KMFDoc *genDoc =  KMyFirewallInterface::instance()->network()->currentDoc();
	if ( KMFGenericDoc* doc = dynamic_cast<KMFGenericDoc*> ( genDoc ) ) {
		kdDebug() << "Returning valid KMFGenericDoc pointer" << endl;
		return doc;
	} 
	return 0;
}

KMFIPTDoc* KMFPlugin::iptablesDoc() {
	KMFDoc *genDoc =  KMyFirewallInterface::instance()->network()->currentDoc();
	if ( KMFIPTDoc* doc = dynamic_cast<KMFIPTDoc*> ( genDoc ) ) {
		kdDebug() << "Returning KMFIPTDoc doc pointer" << endl;
		return doc;
	}
	return 0;
}

KMFRulesetDoc* KMFPlugin::rulesetDoc() {
	KMFDoc *genDoc =  KMyFirewallInterface::instance()->network()->currentDoc();
	if ( KMFRulesetDoc* doc = dynamic_cast<KMFRulesetDoc*> ( genDoc ) ) {
		kdDebug() << "Returning KMFRulesetDoc doc pointer" << endl;
		return doc;
	}
	return 0;
}

void KMFPlugin::setOutputWidget( QWidget* wid ) {
	 KMyFirewallInterface::instance()->setOutputWidget( wid );
}

void KMFPlugin::showEditor() {
	 KMyFirewallInterface::instance()->showEditor();
}

void KMFPlugin::showOutput() {
	 KMyFirewallInterface::instance()->showOutput();
}

void KMFPlugin::checkStatus() {
	 KMyFirewallInterface::instance()->checkStatus();
}

}

