//
// C++ Interface: kmfnethost
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMFNETHOST_H
#define KMFNETHOST_H

#include "kmftarget.h"
#include "netfilterobject.h"


// QT includes
#include <qptrlist.h>
#include <qguardedptr.h>
#include <qstring.h>
#include <qdom.h>
#include <quuid.h>

// KDE includes
#include <kdemacros.h>


// Project includes

namespace KMF {
class KMFGenericDoc;
class KMFProtocol;
class KMFProtocolUsage;
class KMFError;
class KMFCheckInput;
class KMFNetZone;
class IPAddress;
class KMFNetwork;

/**
@author Christian Hubinger
*/

class KDE_EXPORT KMFNetHost : public KMFTarget {
	Q_OBJECT
public:
	KMFNetHost( NetfilterObject *parent, const char* name, const QString& Hostname, KMFNetwork* net );
	virtual ~KMFNetHost();

	virtual int type();
	virtual void clear();
	
	bool logIncoming() {
		return m_logIncoming;
	}
	void setLogIncoming( bool );

	bool logOutgoing() {
		return m_logOutgoing;
	}
	void setLogOutgoing( bool );

	void setLimit( int num, const QString& scale );
	
	bool limit() const;
	int limitRate() const;
	const QString& limitScale() const;
	
	virtual const QDomDocument& getDOMTree();
	virtual void loadXML(const QDomDocument&, QStringList& errors );
	virtual void loadXML( QDomNode, QStringList& errors );
	
	KMFProtocolUsage* addProtocolUsage( const QUuid& protocolUuid, const QDomDocument& xml );
	
	void delProtocolUsage( KMFProtocolUsage*, bool destructive = true );
	bool protocolInherited( const QUuid& uuid ) const;
	KMFProtocolUsage* findProtocolUsageByProtocolUuid( const QUuid& uuid ) const;
	
	QPtrList<KMFProtocolUsage>& protocols() const;

protected slots:
	void slotOnProtocolUsageDeleted( QObject* protocol );
	
private: // Data
// 	int m_maskLen;
	QPtrList<KMFProtocolUsage> m_protocols;
	bool m_logIncoming, m_logOutgoing;
	QString m_limitScale;
	int m_limitNum;
};
}
#endif
