//
// C++ Interface: kmfiptablesdocumentconverter
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
// License: GPL
//
#ifndef KMFIPTABLESDOCUMENTCONVERTER_H
#define KMFIPTABLESDOCUMENTCONVERTER_H

/**
@author Christian Hubinger
*/

#include <qstring.h>
#include <qstringlist.h>
#include <qvaluelist.h>


namespace KMF {
class KMFNetZone;
class KMFNetHost;
class IPTRule;
class IPTChain;
class IPTable;
class KMFIPTDoc;
class KMFProtocol;
class KMFProtocolUsage;
class KMFGenericDoc;
class KMFErrorHandler;
class KMFError;


class KMFIPTablesDocumentConverter{
public:
    KMFIPTablesDocumentConverter();

    ~KMFIPTablesDocumentConverter();
	KMFIPTDoc* compileToIPTDoc( KMFGenericDoc* doc );

private:
	void addToChains( KMFNetZone*, KMFIPTDoc* , IPTChain*, const QString& );
	void createRules( KMFNetZone*, IPTChain*, const QString& );
	void setupLocalhostRules(  KMFGenericDoc*, KMFIPTDoc* );
	void setupConnectionTracking( KMFIPTDoc* );
	void setupPolicies( KMFGenericDoc*, KMFIPTDoc* );
	void createZoneProtocolRules( IPTChain*, KMFProtocolUsage* );
	void createZoneProtocol( IPTChain*, KMFProtocolUsage* prot , const QString& option, const QString& ports );
	void createHostProtocolRules( IPTChain*, KMFNetHost*, KMFProtocolUsage*, const QString& );
	void createHostProtocol( IPTChain*, KMFNetHost*, KMFProtocolUsage* prot , const QString& option, const QString&, const QString& );
	void setupInAndOutHosts( KMFIPTDoc*, KMFNetZone*,  const QString& );
	void setupForbiddenHosts( KMFIPTDoc*, KMFNetZone*, const QString&  );
	
	void setupICMPRules( KMFGenericDoc*, KMFIPTDoc* );
	
	void setupNatRules( KMFGenericDoc*, KMFIPTDoc* );
	void setupNatTarget( KMFGenericDoc*, IPTRule* );
	void setupLogging( KMFGenericDoc*, KMFIPTDoc* );
	void setupLoggingRules( KMFGenericDoc*, IPTChain* );

private: // DATA
	KMFGenericDoc *m_genericDoc;
	KMFErrorHandler *m_errorHandler;
	KMFError *m_err;
	KMFIPTDoc *m_iptdoc;
};
}
#endif
