/***************************************************************************
                          kmplayersource.h  -  description
                             -------------------
    begin                : Sat Mar  24 16:14:51 CET 2003
    copyright            : (C) 2003 by Koos Vriezen
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMPLAYERAPPSOURCE_H
#define KMPLAYERAPPSOURCE_H
 

#include "config-kmplayer.h"

#include <qframe.h>

#include <kurl.h>

#include "kmplayersource.h"
#include "kmplayerconfig.h"


class KMPlayerApp;
class KUrlRequester;
class QMenu;
class QCheckBox;

/*
 * Base class for sources having a sub menu in the application
 */
class KMPLAYER_NO_EXPORT KMPlayerMenuSource : public KMPlayer::Source {
    Q_OBJECT
public:
    KMPlayerMenuSource (const QString & n, KMPlayerApp * app, QMenu * m, const char * src);
    virtual ~KMPlayerMenuSource ();
protected:
    void menuItemClicked (QMenu * menu, int id);
    QMenu * m_menu;
    KMPlayerApp * m_app;
};

/*
 * Preference page for DVD
 */
class KMPLAYER_NO_EXPORT KMPlayerPrefSourcePageDVD : public QFrame {
    Q_OBJECT
public:
    KMPlayerPrefSourcePageDVD (QWidget * parent);
    ~KMPlayerPrefSourcePageDVD () {}

    QCheckBox * autoPlayDVD;
    KUrlRequester * dvddevice;
};

/*
 * Source from DVD
 */
class KMPLAYER_NO_EXPORT KMPlayerDVDSource : public KMPlayerMenuSource, public KMPlayer::PreferencesPage {
    Q_OBJECT
public:
    KMPlayerDVDSource (KMPlayerApp * app, QMenu * m);
    virtual ~KMPlayerDVDSource ();
    virtual bool processOutput (const QString & line);
    virtual QString filterOptions ();
    virtual void setIdentified (bool b = true);
    virtual QString prettyName ();
    virtual void write (KSharedConfigPtr);
    virtual void read (KSharedConfigPtr);
    virtual void sync (bool);
    virtual void prefLocation (QString & item, QString & icon, QString & tab);
    virtual QFrame * prefPage (QWidget * parent);
public slots:
    virtual void activate ();
    virtual void deactivate ();

    void titleMenuClicked (int id);
    void subtitleMenuClicked (int id);
    void languageMenuClicked (int id);
    void chapterMenuClicked (int id);
private:
    void setCurrent (KMPlayer::Mrl *);
    void play ();
    QMenu * m_dvdtitlemenu;
    QMenu * m_dvdchaptermenu;
    QMenu * m_dvdlanguagemenu;
    QMenu * m_dvdsubtitlemenu;
    KMPlayer::NodePtr disks;
    KMPlayerPrefSourcePageDVD * m_configpage;
    int m_current_title;
    bool m_start_play;
};


/*
 * Source from DVDNav
 */
class KMPLAYER_NO_EXPORT KMPlayerDVDNavSource : public KMPlayerMenuSource {
    Q_OBJECT
public:
    KMPlayerDVDNavSource (KMPlayerApp * app, QMenu * m);
    virtual ~KMPlayerDVDNavSource ();
    virtual QString prettyName ();
public slots:
    virtual void activate ();
    virtual void deactivate ();
    virtual void play ();

    void finished ();
    void navMenuClicked (int id);
};


/*
 * Preference page for VCD
 */
class KMPLAYER_NO_EXPORT KMPlayerPrefSourcePageVCD : public QFrame {
    Q_OBJECT
public:
    KMPlayerPrefSourcePageVCD (QWidget * parent);
    ~KMPlayerPrefSourcePageVCD () {}
    KUrlRequester * vcddevice;
    QCheckBox *autoPlayVCD;
};


/*
 * Source from VCD
 */
class KMPLAYER_NO_EXPORT KMPlayerVCDSource : public KMPlayerMenuSource, public KMPlayer::PreferencesPage {
    Q_OBJECT
public:
    KMPlayerVCDSource (KMPlayerApp * app, QMenu * m);
    virtual ~KMPlayerVCDSource ();
    virtual bool processOutput (const QString & line);
    virtual void setIdentified (bool b = true);
    virtual QString prettyName ();
    virtual void write (KSharedConfigPtr);
    virtual void read (KSharedConfigPtr);
    virtual void sync (bool);
    virtual void prefLocation (QString & item, QString & icon, QString & tab);
    virtual QFrame * prefPage (QWidget * parent);
public slots:
    virtual void activate ();
    virtual void deactivate ();
private:
    void setCurrent (KMPlayer::Mrl *);
    KMPlayerPrefSourcePageVCD * m_configpage;
    bool m_start_play;
};


/*
 * Source from AudoCD
 */
class KMPLAYER_NO_EXPORT KMPlayerAudioCDSource : public KMPlayerMenuSource {
    Q_OBJECT
public:
    KMPlayerAudioCDSource (KMPlayerApp * app, QMenu * m);
    virtual ~KMPlayerAudioCDSource ();
    virtual bool processOutput (const QString & line);
    virtual void setIdentified (bool b = true);
    virtual QString prettyName ();
public slots:
    virtual void activate ();
    virtual void deactivate ();
private:
    void setCurrent (KMPlayer::Mrl *);
};


/*
 * Source from stdin (for the backends, not kmplayer)
 */
class KMPLAYER_NO_EXPORT KMPlayerPipeSource : public KMPlayer::Source {
    Q_OBJECT
public:
    KMPlayerPipeSource (KMPlayerApp * app);
    virtual ~KMPlayerPipeSource ();
    virtual bool hasLength ();
    virtual bool isSeekable ();
    void setCommand (const QString & cmd);
    virtual QString prettyName ();
public slots:
    virtual void activate ();
    virtual void deactivate ();
private:
    KMPlayerApp * m_app;
};

#endif // KMPLAYERAPPSOURCE_H
