/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef C_CONFIG_H
#define C_CONFIG_H

#include <kconfigskeleton.h>
#include <qlistview.h> 

#include <iostream>
using namespace std;

/**
@author Marco Gulino
*/
class c_config : public KConfigSkeleton
{
public:
    c_config();

    ~c_config();
	QString getDevice() { return device; }
	QString getEncoding() { return encoding; }
    bool isVerbose() { return verbose; }
	bool getMotoBattery() { return motoBattery; }
	bool getDalOpts() { return dialOpts; }
	int getPhoneProfile() { return phoneProfile; }
	
	bool chgDevice() { return !(device==old_device); }
	bool chgEncoding() { return !(encoding==old_encoding); }
	bool chgVerbose() { return !(verbose==old_verbose); }
	bool chgBaudrate() { return !(baudrate==oldBaudrate); }
	
	void upgradeOlds() { old_device=device; old_encoding=encoding; old_verbose=verbose; oldBaudrate=baudrate; }
	void printOlds() { 
		cout << "Old Device:" << old_device << ", Old encoding:" << old_encoding << ", Old Verbose:" << old_verbose << endl; 
	}
    int getBaudRate();
	int getPbOverwrite() { return pb_overwrite; }
	int getPbImportFormat() { return pb_importFormat; }
	bool getPbClear() { return pb_clear; }
	bool getFirstTime() { return firstTime; }
	void setFirstTime( bool val ) { firstTime=val; }
	bool getSMSMode2() { return sms_mode2; }
	bool getSMSMemChg() { return smsmemchg; }
	bool getPbMemChg() { return pbmemchg; }
	QStringList getSMSMemAval() { return sms_mem_avail; }
	QStringList getSMSMemUsed(){ return sms_mem_used; }
	QStringList getPbMemAval(){ return pb_mem_avail; }
	QStringList getPbMemUsed(){ return pb_mem_used; }
 QString getSMSSaveSlot() { return sms_saveslot; }
 QString getInitString() { return initString; }
 QString getInitString_2() { return initString_2; }
	
	void setSMSSaveSlot( QString saveSlot) { sms_saveslot=saveSlot; }
	void setSMSMemAval( const QStringList strList ) { sms_mem_avail=strList; }
	void setSMSMemUsed( const QStringList strList ){ sms_mem_used=strList; }
	void setPbMemAval( const QStringList strList ){ pb_mem_avail=strList; }
	void setPbMemUsed( const QStringList strList ){ pb_mem_used=strList; }
	
	int getLastPbMemUsed() { return lastPbMemUsed; }
	void setLastPbMemUsed( int val ) { lastPbMemUsed=val; }
	
	// Some constants
	static const int CKPD_DIAL=0;
	static const int AT_DIAL=1;
	static const int GENERIC  = 0;
	static const int MOTOROLA = 1;
	static const int NOKIA    = 2;
	static const int ERICSSON = 3;
		
protected:
	QString device;
	QString encoding;
	int phoneProfile, dialOpts, baudrate;
	bool motoBattery;
	int lastPbMemUsed;
	bool verbose;
	int pb_overwrite;
	int pb_importFormat;
	bool pb_clear;
	bool sms_mode2;
	QStringList sms_mem_avail, sms_mem_used;
	QStringList pb_mem_avail, pb_mem_used;
	QString sms_saveslot;
	
	QString old_device;
	QString old_encoding;
	bool old_verbose;
	int oldBaudrate;
	bool firstTime;
	bool smsmemchg, pbmemchg;
 QString initString;
 QString initString_2;

};

#endif
