/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                *
 *                                                                         *
 *   This p
 rogram is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef THREADEDGSM_H
#define THREADEDGSM_H

#include <qthread.h>
#include <qvaluelist.h> 
#include <qstringlist.h>

/**
@author Marco Gulino
*/
class threadedGSM : public QThread
{
public:
   virtual void run();
   void delSMS( const QString id ) 
   { delQueue+=id; }
   void initPhoneBook() { initPhoneBookFlag=true; }
   void setShutdown() { active=false; }
   void togglePaused(bool pauseFlag) { paused=pauseFlag; }
   bool getPaused() { return pausedStatus; }
   
   private:
   QStringList delQueue;
   bool initPhoneBookFlag;
   bool active;
   bool paused;
   bool pausedStatus;
};

#endif
