/* -*- c++ -*-
*
* main.cpp
*
* Copyright (C) 2003, 2004 Petter E. Stokke <gibreel@kmldonkey.org>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*/

#include "version.h"
#include "mmserver.h"
#include "corelauncher.h"
#include "previewstreamer.h"
#include "main.h"

#include <kconfig.h>
#include <kdebug.h>

KDEDKMLDonkey::KDEDKMLDonkey( const QCString& name )
        : KDEDModule( name )
{
    kdDebug( 7020 ) << "KDEDKMLDonkey::KDEDKMLDonkey(\"" << name << "\")" << endl;
    mmserver = 0;
    launcher = new CoreLauncher(this);
    mmcfg = new KConfig( "mobilemulerc", true, false );
    mmcfg->setGroup( "MobileMule" );
    setMobileMuleEnabled( mmcfg->readBoolEntry( "Autostart", false ) );
    streamer = new PreviewStreamerServer();
    kdDebug( 7020 ) << "KDEDKMLDonkey initialised." << endl;
}

KDEDKMLDonkey::~KDEDKMLDonkey()
{
    kdDebug( 7020 ) << "KDEDKMLDonkey::~KDEDKMLDonkey()" << endl;
    delete mmserver;
    delete mmcfg;
    delete streamer;
}

void KDEDKMLDonkey::setMobileMuleEnabled( bool state )
{
    if ( state && !mmserver ) {
        int port = mmcfg->readNumEntry( "Port", 4081 );
        QString password = mmcfg->readEntry( "Password", "" );
        mmserver = new MMServer( "0.0.0.0", port, QString::null, password );
    } else if ( !state && mmserver ) {
        delete mmserver;
        mmserver = 0;
    }
}

void KDEDKMLDonkey::enableMobileMule()
{
    setMobileMuleEnabled( true );
}

void KDEDKMLDonkey::disableMobileMule()
{
    setMobileMuleEnabled( false );
}

bool KDEDKMLDonkey::mobileMuleEnabled() const
{
    return ( bool ) mmserver;
}

void KDEDKMLDonkey::startCore(const QString& name)
{
    launcher->startCore(name);
}

void KDEDKMLDonkey::stopCore(const QString& name)
{
    launcher->stopCore(name);
}

bool KDEDKMLDonkey::isCoreRunning(const QString& name)
{
    return launcher->isCoreRunning(name);
}

bool KDEDKMLDonkey::isValidCore(const QString& name)
{
    return launcher->isValidCore(name);
}

QStringList KDEDKMLDonkey::coreNames()
{
    return launcher->coreNames();
}

extern "C"
{
    KDEDModule *create_kmldonkeyd( const QCString & name ) {
        return new KDEDKMLDonkey( name );
    }
}

#include "main.moc"
