/* -*- c++ -*-
 *
 * webservices.cpp
 *
 * Copyright (C) 2003, 2005 Petter E. Stokke <gibreel@kmldonkey.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include <kdebug.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <fileinfo.h>

#include <donkeyprotocol.h>

#include "kmldonkey.h"
#include "webservices.h"
#include "webservices.moc"


FileInfoWebBrowser::FileInfoWebBrowser(int fileno, QWidget* parent, const char* name)
    : WebBrowser(parent, name)
{
    fn = fileno;
    loaded = false;
}

void FileInfoWebBrowser::handleED2K(const ED2KURL& url)
{
    FileInfo* fi = KMLDonkey::App->donkey->findDownloadFileNo(fn);

    if (url.isSameFile(fi)) {
	QString body = i18n("Do you want to rename \"%1\" to \"%2\"?").arg(fi->fileName()).arg(url.fileName());
	if (KMessageBox::questionYesNo(this, body, i18n("Rename download")) == KMessageBox::Yes) {
	    QString foo = "rename " + QString::number(fn) + " \"" + url.fileName() + "\"";
	    KMLDonkey::App->sendConsoleMessage(foo);
	    KMLDonkey::App->donkey->refreshFileInfo(fn);
	}
    }
    else WebBrowser::handleED2K(url);
}

void FileInfoWebBrowser::showEvent(QShowEvent* event)
{
    WebBrowser::showEvent(event);
    if (loaded) return;
    loaded = true;
    loadWebPage();
}



RazorbackFileInfo::RazorbackFileInfo(int fileno, QWidget* parent)
    : FileInfoWebBrowser(fileno, parent, "RazorbackFileInfo")
{
}

void RazorbackFileInfo::loadWebPage()
{
    FileInfo* fi = KMLDonkey::App->donkey->findDownloadFileNo(fn);
    if (!fi) {
	openURL(KURL("http://stats.razorback2.com/"));
	return;
    }

    KURL url(QString("http://stats.razorback2.com/ed2khistory?ed2k=") + fi->fileUid("ed2k"));
    openURL(url);
}



DonkeyFakesFileInfo::DonkeyFakesFileInfo(int fileno, QWidget* parent)
    : FileInfoWebBrowser(fileno, parent, "DonkeyFakesFileInfo")
{
}

void DonkeyFakesFileInfo::loadWebPage()
{
    FileInfo* fi = KMLDonkey::App->donkey->findDownloadFileNo(fn);
    if (!fi) {
	openURL(KURL("http://donkeyfakes.gambri.net/"));
	return;
    }

    KURL url(QString("http://donkeyfakes.gambri.net/index.php?action=search&ed2k=&hash=") + fi->fileUid("ed2k"));
    openURL(url);
}



EMugleFileInfo::EMugleFileInfo(int fileno, QWidget* parent)
    : FileInfoWebBrowser(fileno, parent, "EMugleFileInfo")
{
}

void EMugleFileInfo::loadWebPage()
{
    FileInfo* fi = KMLDonkey::App->donkey->findDownloadFileNo(fn);
    if (!fi) {
	openURL(KURL("http://www.emugle.com/"));
	return;
    }

    KURL url(QString("http://www.emugle.com/details.php?f=") + fi->fileUid("ed2k").upper());
    openURL(url);
}

