/***************************************************************************
 *   Copyright (C) 2009 by Spiros Georgaras                                *
 *   sng@hellug.gr                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <iostream>
#include "kmhtconvert.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kmimetype.h>
#include <ksharedptr.h>
#include <ktar.h>

#include <qobject.h>
#include <qfileinfo.h>
#include <qtextcodec.h>
#include "MHT.h"
#include "WAR.h"

QString toLocale(const QString &msg);

static const char description[] =I18N_NOOP("A Web Archive Converter");

static const char version[] = "0.7.4";

static KCmdLineOptions options[] =
{
	{"n",0,0},
	{"NoGui",I18N_NOOP("Execute without the GUI"), 0},
	{"s",0,0},
	{"silent",I18N_NOOP("Only report errors when executed without the GUI"), 0},
	{"f",0,0},
	{"onlyFiles",I18N_NOOP("Create a folder containing the files.\nDon't Create War file"), 0},
	{"w",0,0},
	{"viewWar",I18N_NOOP("Create War file in tmp folder\nand view it in Konqueror"), 0},
	{ "d <folder>", I18N_NOOP("Folder to save the output file"), 0 },
	{"i",0,0},
	{"hideInfo",I18N_NOOP("Hide info table in EML files"), 0},
	{"a",0,0},
	{"hideAttachments",I18N_NOOP("Hide attachments table in EML files"), 0},
	{ "+[file]", I18N_NOOP( "MHTML/WAR file to convert" ), 0 },
	KCmdLineLastOption
};
MHT mhtToWarFile;
bool silent;
bool useGui;
bool onlyFile;
bool viewOnly;
bool hideAttachments;
bool hideInfo;
//bool createMHT;
QString fName;
KAboutData* ab;
kmhtConvert* ptrMainWindow=0;

int main(int argc, char **argv)
{
	bool createMHT=FALSE;
	fName="";
	KAboutData about("kmhtconvert", I18N_NOOP("kmhtConvert"), version, description,
		KAboutData::License_GPL, "(C) 2004 - 2009 Spiros Georgaras", 0, "http://members.hellug.gr/sng/kmhtconvert/", "sng@hellug.gr");
	about.addAuthor( "Spiros Georgaras", 0, "sng@hellug.gr" );
	ab=&about;
	KCmdLineArgs::init(argc, argv, &about);
	KCmdLineArgs::addCmdLineOptions( options );

	KApplication app;
/*
			int accuracy1=0;
			KMimeType::Ptr mt1 = KMimeType::findByFileContent("/d/fun/Belonaki.war" , &accuracy1 );
			std::cout << mt1->name() << std::endl;
			return 0;
*/


// 	QCString a[2];
// 	a[0].sprintf("%c",10);
// 	a[1]="";
// 	kdDebug()<< "a[0] isNull=" << a[0].isNull() << ", isEmpty=" << a[0].isEmpty() << endl;
// 	kdDebug()<< "a[1] isNull=" << a[1].isNull() << ", isEmpty=" << a[1].isEmpty() << endl;
// 	// result is
// 	//		kmhtconvert: a[0] isNull=false, isEmpty=false
// 	//		kmhtconvert: a[1] isNull=false, isEmpty=true
//
// 	return 0;


	kmhtConvert *mainWin = 0;
	silent=FALSE;
	useGui=TRUE;
	onlyFile=FALSE;
	viewOnly=FALSE;
	hideAttachments=FALSE;
	hideInfo=FALSE;
//	createMHT=FALSE;
	//QString fName("");
	QString outDir("");
	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
	if(args->isSet("onlyFiles")){
		onlyFile=TRUE;
		mhtToWarFile.setNoSaveWarFile(TRUE);
	}
	if(args->isSet("silent")) silent=TRUE;
	if(args->isSet("NoGui")) useGui=FALSE;
//	if(args->isSet("reverse")) createMHT=TRUE;
	if(args->isSet("viewWar")){
		viewOnly=TRUE;
		mhtToWarFile.setViewWarFile(TRUE);
	}
	//if(!silent && !useGui) std::cout << "kmhtConvert v " << version << " -  � 2009 S. Georgaras <sng@hellug.gr>" << std::endl<< std::endl;
	if(args->count()>0){
		if( (viewOnly && (!useGui || onlyFile || args->isSet("d"))) ||
				(createMHT && (onlyFile || viewOnly)) ){
			if(!useGui)std::cout << i18n(QString("Conflicting command line parameters used...")).local8Bit() << std::endl;
			else KMessageBox::error(0,i18n(QString("Conflicting command line parameters used...")),0);
			args->clear();
			return 1;
		}
		fName=args->url(0).url();
		KURL fURL(fName);
		//kdDebug()<<fName.local8Bit()<<endl;
		//kdDebug()<<fURL.isLocalFile()<<endl;
		if(!fURL.isLocalFile()){
			if(!useGui)std::cout << i18n(QString("kmhtConvert can handle only local files...")).local8Bit() << std::endl;
			else KMessageBox::error(0,i18n(QString("kmhtConvert can handle only local files...")),0);
			args->clear();
			return 1;
		}
		fName=args->url(0).path();
		//kdDebug()<<fName.local8Bit()<<endl;
		QFileInfo ff(fName);
		if(!ff.exists()){
			if(useGui){
				KMessageBox::error(0,i18n(QString("The input file does not exist")),0);
				args->clear();
				return 1;
			}else{
				std::cout << i18n(QString("The input file does not exist")).local8Bit() << std::endl;
				args->clear();
				return 1;
			}
		}else{
			if(fName.endsWith(".war",FALSE)) createMHT=TRUE;
			else if (fName.endsWith(".mhtml",FALSE) || fName.endsWith(".mht",FALSE) || fName.endsWith(".eml",FALSE)) createMHT=FALSE;
			else{
				if(!useGui)std::cout << i18n(QString("The input file is not a Web Archive...")).local8Bit() << std::endl;
				else KMessageBox::error(0,i18n(QString("The input file is not a Web Archive...")),0);
				args->clear();
				return 1;
			}
			if(!ff.isReadable()){
				if(useGui) KMessageBox::error(0,i18n(QString("You don't have read permission to the input file")),0);
				else std::cout << i18n(QString("You don't have read permission to the input file")).local8Bit() << std::endl;
				args->clear();
				return 1;
			}
		}
	}else{
		if(!useGui){
			std::cout << i18n(QString("No input file specified")).local8Bit() << std::endl;
			args->clear();
			return 1;
		}else{
			if(viewOnly){
				KMessageBox::error(0,i18n(QString("No input file specified")),0);
				args->clear();
				return 1;
			}
		}
	}
	if(args->isSet("d")){
		//outDir = QString::fromUtf8(args->getOption("d"));
		outDir = args->getOption("d");
		QFileInfo mFile(outDir);
		if(!mFile.exists()){
			if(useGui){
				KMessageBox::error(0,i18n(QString("The ouput folder does not exist")).local8Bit(),0);
				outDir=QString("");
			}else{
				std::cout << i18n(QString("The ouput folder does not exist")).local8Bit() << std::endl;
				args->clear();
				return 1;
			}
		}else if(!mFile.isDir()){
			if(useGui){
				KMessageBox::error(0,i18n(QString("Invalid output folder specified")).local8Bit(),0);
				outDir=QString("");
			}else{
				std::cout << i18n(QString("Invalid output folder specified")).local8Bit() << std::endl;
				args->clear();
				return 1;
			}
		}else if(!mFile.isWritable()){
			if(useGui){
				KMessageBox::error(0,i18n(QString("You don't have write permission to the output folder")),0);
				outDir=QString("");
			}else{
				std::cout << i18n(QString("You don't have write permission to the output folder")).local8Bit() << std::endl;
				args->clear();
				return 1;
			}
		}
	}
	if(args->isSet("i")) hideInfo=TRUE;
	if(args->isSet("a")) hideAttachments=TRUE;
	args->clear();
	if(!useGui){
		if(!silent) std::cout << i18n(QString("Input file")).local8Bit() + ": ";
		QString fnametodisplay;
		int c=fName.findRev('/');
		fnametodisplay=fName.mid(c+1);
		if(!silent) std::cout << toLocale(fnametodisplay) << std::endl;
		if(createMHT){
			// War --> mht
			WAR warToMhtFile;
			warToMhtFile.setName(fName,outDir,silent,useGui);
			return 0;
		}else{
			// mht --> War
			mhtToWarFile.setSilent(silent);
			mhtToWarFile.setUseGui(useGui);
			mhtToWarFile.setFile(fName, outDir, hideInfo, hideAttachments);
			//return 0; // test case
			if(mhtToWarFile.status==1){
				std::cout << i18n(QString("Error opening file")).local8Bit() << std::endl;
				return 1;
			}else if(mhtToWarFile.status==2 || mhtToWarFile.status==3){
				std::cout << i18n(QString("File is corrupt")).local8Bit() << std::endl;
				return 1;
			}else if(mhtToWarFile.status==4){
				std::cout << i18n(QString("File type not supported")).local8Bit() << std::endl;
				return 1;
			}
			//std::cout << "Boundary = " << mhtToWarFile.boundary << std::endl;
			if(!silent){
				QString oName;
				int u=-1;
				while((u=fName.find("/",u+1))!=-1) oName=fName.mid(u+1);
				//if(!silent && !onlyFile)
				if(!silent)
						std::cout << i18n(QString("Files in archive: ")).local8Bit() << mhtToWarFile.items() << std::endl;
			}
			if(!mhtToWarFile.extractAllFiles()){
				if(silent)
						std::cout << i18n(QString("Error extracting file")).local8Bit() << std::endl;
				else
						std::cout << std::endl << i18n(QString("Error extracting file")).local8Bit() << std::endl;
				return 1;
			}
			if(!silent && !onlyFile)
					std::cout << i18n(QString("Creating output file")).local8Bit()<< " .... ";
			if(!onlyFile) if(!mhtToWarFile.createWarArchive()){
				if(silent)
						std::cout << i18n(QString("Error creating output file")).local8Bit() << std::endl;
				else
						std::cout << std::endl << i18n(QString("Error creating output file")).local8Bit() << std::endl;
				return 1;
			}
			if(!silent && !onlyFile) std::cout << i18n(QString("done")).local8Bit() << std::endl << std::endl;
			return 0;
		}
	}
	mainWin = new kmhtConvert(outDir,hideInfo,hideAttachments);
	app.setMainWidget( mainWin );
	mainWin->show();
	args->clear();
	return app.exec();
}

QString toLocale(const QString &msg){
	QString tmpOut=(const char *)msg;
	QTextCodec *codec = QTextCodec::codecForLocale();
	if(!codec) return msg;
	QCString out;
	out=codec->fromUnicode(msg);
	return out;
}
