/***************************************************************************
                          inkedit.cpp -  description
                             -------------------
    begin                : Wed May 14 2008
    copyright            : (C) 2008 by Antonio Nastasi
    email                : sifcenter@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INKEDIT_H
#define INKEDIT_H

#include "ui_inkedit.h"


// Structure to hold image data
struct InkImage
{
  // Structure initializer
  InkImage()
  {
    initialized = false;
  }

  // Is the image initialized?
  bool   initialized;
  // Ink image pixels
  QImage pixels;
  // Rectangle containing the drawing
  QRect  area;
};



class InkEdit : public QWidget, public Ui::InkEdit
{
  Q_OBJECT

  public:
    // Constructor
                        InkEdit( QWidget *parent = 0 );
    // Return the image
    InkImage           *getImage();
    // Return the bytes representing the image
    const QByteArray   &getImageBytes();
    // Returns true if the image is empty
    bool                isEmpty();
    // Change the image
    void                setImage( InkImage *newImage );

  public slots:
    // Clear the current image
    void                clearImage();

  protected: // protected methods
    // Implements all events to grep the mouse pointer
    void                mousePressEvent( QMouseEvent *event );
    void                mouseMoveEvent( QMouseEvent *event );
    void                mouseReleaseEvent( QMouseEvent *event );
    void                paintEvent( QPaintEvent *event );
    void                resizeEvent( QResizeEvent *event );

  private: // private methods
    // Crop the image to send only the drawed area
    void                cropImage( QPoint position );
    // Draw a line from start point to last point
    void                drawLineTo( const QPoint &endPoint );
    // Resize image method
    void                resizeImage( QImage *image, const QSize &newSize );

  private slots:
    // Change color for current pen
    void                changeColor();
    // Erase brush was selected
    void                eraseBrush();

  private: // private attribute
    // Color of current pen
    QColor              color_;
    // It's true if the erase brush was selected.
    bool                erasingImage_;
    // Current image data
    InkImage           *image_;
    // The bytes of image
    QByteArray          imageBytes_;
    // Variable to store if the image is empty or not
    bool                isEmpty_;
    // Last point where the mouse pointer was released
    QPoint              lastPoint_;
    // True if the user is painting
    bool                scribbling_;

  signals:
    // Emitted when the ink was modified
    void                inkChanged();
};

#endif
