#!/bin/sh

cd `dirname $0`/..

# second sed expression fixes Mac OS X 10.4
appver="`egrep 'SET.*KMESS_VERSION' CMakeLists.txt | sed -e 's/.*"\([^"]*\)".*/\1/'`"
date="`date +%Y%m%d`"

# Make sure we have the right repository
if [ ! -f kmess.kdevelop ]; then
  /bin/echo -n "git (unknown)"
  exit
fi

# display app version if git isn't installed.
if [ ! -x `which git` ]; then
  /bin/echo -n "$appver"
  exit
fi

# Display subversion version if this is a working copy
gitver=`git rev-parse HEAD`

# display last 8 digits of HEAD SHA-1 + date
/bin/echo -n "$appver-git (${gitver:0:8} >= $date)"
