/***************************************************************************
                          idletimer.cpp  -  description
                             -------------------
    begin                : Tue Oct 22 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "idletimer.h"

#include "../currentaccount.h"
#include "../kmessdebug.h"
#include "xautolock.h"



// The constructor
IdleTimer::IdleTimer()
: QObject()
{
  watcher_ = new XAutoLock();
  // Connect the timer to signal when the user is away.
  connect( watcher_, SIGNAL( timeout()       ),
           this,     SLOT  ( slotTimeout()   ) );
  connect( watcher_, SIGNAL( activity()      ),
           this,     SLOT  ( slotActivity()  ) );
  watcher_->stopTimer();
  // Make the connections
  connect( CurrentAccount::instance(), SIGNAL( changedTimerSettings() ),
           this,                       SLOT  ( updateWatcher()        ) );
}



// The destructor
IdleTimer::~IdleTimer()
{
  delete watcher_;
#ifdef KMESSDEBUG_IDLETIMER
  kDebug() << "DESTROYED.";
#endif
}



// Echo the watcher's timeout.
void IdleTimer::slotTimeout()
{
  emit timeout();
}



// Echo the watcher's activity .
void IdleTimer::slotActivity()
{
  emit activity();
}



// Reset the watcher based on the account's settings.
void IdleTimer::updateWatcher()
{
#ifdef KMESSDEBUG_IDLETIMER
  kDebug();
#endif
  Account *account = CurrentAccount::instance();
  watcher_->setTimeOut( account->getIdleTime() * 60 );
  if ( account->getUseIdleTimer() )
  {
#ifdef KMESSDEBUG_IDLETIMER
    kDebug() << "Start the timer.";
#endif
    watcher_->startTimer();
  }
  else
  {
#ifdef KMESSDEBUG_IDLETIMER
    kDebug() << "Stop the timer.";
#endif
    watcher_->stopTimer();
  }
#ifdef KMESSDEBUG_IDLETIMER
  kDebug() << "Done updateWatcher().";
#endif
}

#include "idletimer.moc"
