/***************************************************************************
                          nowlisteningclient.h -  description
                             -------------------
    begin                : Sat Nov 4 2006
    copyright            : (C) 2006 by Diederik van der Boor
    email                : "vdboor" --at-- "codingdomain.com"
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NOWLISTENINGCLIENT_H
#define NOWLISTENINGCLIENT_H

#include <qtimer.h>

class DCOPClient;
class QCString;


/**
 * @brief  Helper class to query common media players for "now listening to" information.
 *
 * It uses DCOP calls to other applications to query the information.
 * The applications are polled for information every 5 seconds.
 * The KMess class holds a reference to this helper,
 * and calls setEnabled() to start or stop the detection.
 * When the current song changed, the changedSong() signal will be fired.
 *
 * @author Diederik van der Boor
 * @ingroup Root
 */
class NowListeningClient : public QObject
{
  Q_OBJECT

  public:
    // The construtor
                       NowListeningClient();
    // The destructor
    virtual           ~NowListeningClient();

  public:
    // Enable or disable the update interval timer.
    void               setEnabled( bool enable );

  public slots:
    // Update the current song
    void               slotUpdate();

  private:
    // Make a call to a boolean function
    bool               callDcop( const QCString &app, const QCString &object, const QCString &method,
                                 const QByteArray &args, bool &returnValue ) const;
    // Make a call to a integer function
    bool               callDcop( const QCString &app, const QCString &object, const QCString &method,
                                 const QByteArray &args, int &returnValue ) const;
    // Make a call to a QString function
    bool               callDcop( const QCString &app, const QCString &object, const QCString &method,
                                 const QByteArray &args, QString &returnValue ) const;
    // Make a call to a QString function with QString argument
    bool               callDcop( const QCString &app, const QCString &object, const QCString &method,
                                 const QString &arg1, QString &returnValue ) const;
    // Find a DCOP application that starts with the given app name.
    QCString           findDcopApplication( const QCString &appName ) const;

    // Query Amarok for track information
    bool               queryAmarok();
    // Query Juk for track information
    bool               queryJuk();
    // Query Kaffeine for track information
    bool               queryKaffeine();
    // Query KsCD for track information
    bool               queryKsCD();
    // Query Noatun for track information
    bool               queryNoatun();

  private:
    // The active album
    QString            album_;
    // The active artist
    QString            artist_;
    // The DCOP client
    DCOPClient        *client_;
    // Whether the user is currently playing a title.
    bool               playing_;
    // The interval timer
    QTimer             timer_;
    // The active track
    QString            track_;

  signals:
    void               changedSong( const QString &artist, const QString &album, const QString &track, bool playing );
};

#endif
