/***************************************************************************
                          passivepopupview.h -  Displays the passive popup
                            contents
                             -------------------
    begin                : Tuesday April 10 2007
    copyright            : (C) 2007 by Valerio Pilo
    email                : amroth@coldshock.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PASSIVEPOPUPVIEW_H
#define PASSIVEPOPUPVIEW_H

#ifndef PASSIVEPOPUPINTERFACE_H
#include "passivepopupinterface.h"
#endif

#include <kiconloader.h>
#include <kglobal.h>



/**
  * @brief Passive popups layout interface
  *
  * This class derives the passive popup's ui file to insert
  * the layout into the actual popup balloon.
  * The actual layout is defined in the passivepopupinterface.ui file.
  *
  * @author Valerio Pilo <amroth@coldshock.net>
  */
class PassivePopupView : public PassivePopupInterface
{
  Q_OBJECT

  public:  // Public methods
    // Class constructor
    PassivePopupView(  QWidget *parent, QString icon, QString message, QString icon = QString::null );
    // Changes the popup icon
    void changeIcon( QString icon );
    // Changes the popup status icon
    void changeStatusIcon( QString status );
    // Changes the popup message
    void changeMessage( QString message );

  private:  // Private properties
    // Icons loader
    KIconLoader *iconLoader_;
};

#endif
