/***************************************************************************
                          notificationnewemail.cpp - notifies when a
                            new email has arrived
                             -------------------
    begin                : Tuesday April 10 2007
    copyright            : (C) 2007 by Valerio Pilo
    email                : amroth@coldshock.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "notificationnewemail.h"

#include <qpixmap.h>
#include <qfile.h>
#include <qstylesheet.h>

#include <kdebug.h>
#include <klocale.h>

#include <kaudioplayer.h>
#include <knotifyclient.h>

#include "../kmessdebug.h"



// Class constructor
NotificationNewEmail::NotificationNewEmail( NotificationManager* manager )
  : isEnabled_(true)
  , manager_(manager)
{
}



// Notify the user about this event (a new email has arrived)
void NotificationNewEmail::notify( QString sender, QString subject, bool inInbox, QString command, QString folder, QString url )
{
  // If notifications are disabled, do nothing.
  if( !isEnabled_ )
    return;

  currentAccount_ = CurrentAccount::instance();

  if( !inInbox && !currentAccount_->getShowOtherFolders() )
  {
#ifdef KMESSDEBUG_NOTIFICATIONNEWEMAIL
    kdDebug() << "NotificationNewEmail:notify() - New email notification disabled for non-inbox messages." << endl;
#endif
    return;
  }

#ifdef KMESSDEBUG_NOTIFICATIONNEWEMAIL
  kdDebug() << "NotificationNewEmail:notify() - New email from " << sender << " in inbox: " << inInbox << "." << endl;
#endif


  QString      text;
  QStringList  stringList;
  stringList.append( command );
  stringList.append( folder  );
  stringList.append( url     );

  text = i18n( "<b>New email:</b><br>'%1'<br>by '%2'" )
               .arg( QStyleSheet::escape( subject ) )
               .arg( QStyleSheet::escape( sender  ) );


  // Display a popup for this event
  PassivePopup::PopupProperties props;
  props.source = sender;
  props.message = text;
  props.icon = "envelope";
  props.status = "";
  props.destMessages = stringList;
  props.destObject = 0;

  manager_->notify( this, props );


  // Also play a sound
#ifdef KMESSDEBUG_NOTIFICATIONNEWEMAIL
  kdDebug() << "NotificationNewEmail::notify() - Play the default sound." << endl;
#endif
  KNotifyClient::event( manager_->getTrayWidget()->winId(), "new email", text );
}



// Trigger this event's action (Open the mailbox where the new mail is)
void NotificationNewEmail::activate( QStringList stringList, QObject */*object*/ )
{
  // Open hotmail at the given email
  currentAccount_->openMail( stringList[0], stringList[1], stringList[2] );
}



// Enable or disable the new email notifications
void NotificationNewEmail::setEnabled( bool enable )
{
  isEnabled_ = enable;
}



#include "notificationnewemail.moc"
