/***************************************************************************
                          transferfile.h  -  description
                             -------------------
    begin                : Mon Mar 24 2003
    copyright            : (C) 2003 by Mike K. Bennett
                           (C) 2005 by Diederik van der Boor
    email                : mkb137b@hotmail.com
                           vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILETRANSFER_H
#define FILETRANSFER_H

#include "mimeapplication.h"
#include <qobject.h>


class MsnFtpConnection;
class QFile;

/**
 * The class for sending a file to a contact.
 *
 * @author Mike K. Bennett (original SendFile/ReceiveFile/TransferFile classes), Diederik van der Boor (FileTransfer/MsnFtpConnection classes)
 * @ingroup Applications
 */
class FileTransfer : public MimeApplication
{
  Q_OBJECT

  public:
    // The constructor without filename (sufficient for incoming sessions)
                           FileTransfer(const QString &contactHandle);
    // The constructor with filename to start a session
                           FileTransfer(const QString &contactHandle, const QString &filename);
    // The destructor
                          ~FileTransfer();
    // Return the application's GUID
    static QString         getAppId();
    // The user cancelled the session
    void                   userAborted();

  private: // Private methods
// Connect signals of the MsnFtpConnection object
    void                   connectMsnFtpConnection();
    // Step one of a contact-started chat: the contact invites the user
    void                   contactStarted1_ContactInvitesUser(const MimeMessage& message);
    // Step two of a contact-started chat: the user accepts
    void                   contactStarted2_UserAccepts();
    // Step three of a contact-started chat: the contact confirms the accept
    void                   contactStarted3_ContactConfirmsAccept(const MimeMessage& message);
    // Return a cancel message to display
    QString                getUserAbortMessage() const;
    // Create and initilize the progress dialog.
    void                   initializeProgressDialog(bool incoming = false);
    // Convert a string to some more readable form
    QString                toReadableBytes(uint bytes);
    // Step one of a user-started chat: the user invites the contact
    void                   userStarted1_UserInvitesContact();
    // Step two of a user-started chat: the contact accepts
    void                   userStarted2_ContactAccepts(const MimeMessage& message);
    // Step three of a user-started chat: the user prepares for the session
    void                   userStarted3_UserPrepares();

  private slots:
    // Cancelled a file transfer from the TransferWindow
    void                   slotCancelTransfer( int transferID );
    // The direct connection was established
    void                   slotMsnFtpConnectionEstablished();
    // Display a status message
    void                   slotMsnFtpStatusMessage(QString message, int statusType);
    // Signal that the transfer was succesful
    void                   slotMsnFtpTransferComplete();
    // Signal that the transfer failed
    void                   slotMsnFtpTransferFailed();
    // Update the progress dialog with the number of bytes transferred.
    void                   slotMsnFtpTransferProgess(unsigned long bytesReceived);


  private: // Private attributes
    // The connection was established
    bool                   connectionEstablished_;
    // The connectivity parameter of the received invitation
    char                   connectivity_;
    // The file to be saved or sent
    QFile                 *file_;
    // The complete file name
    QString                fileName_;
    // The file size in bytes
    unsigned long          fileSize_;
    // The server socket which listens for incoming connections.
    MsnFtpConnection      *msnFtpConnection_;
    // The short file name
    QString                shortFileName_;
    // The ID of this transfer, used by the Transfer Window
    int                    transferID_;
};

#endif
