/***************************************************************************
                          websidebar.cpp -  description
                             -------------------
    begin                : Sat Oct 8 2005
    copyright            : (C) 2005 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "websidebar.h"

#include <qlayout.h>

#include <khtml_part.h>
#include <khtmlview.h>
#include <kparts/browserextension.h>

#include "../kmessdebug.h"
#include "../network/soap/msnappdirectoryservice.h"


WebSidebar::WebSidebar(QWidget *parent, const char *name)
  : QWidget(parent, name)
  , appdirService_(0)
  , khtml_(0)
{
  setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Preferred, false);  // Stretch widget
  QBoxLayout *layout = new QHBoxLayout( this );

  khtml_ = new KHTMLPart(this, "KHTMLPart");
  layout->addWidget( khtml_->view() );   // Stretches widget

  // Enable all features msn games might use
  khtml_->setJScriptEnabled(true);
  khtml_->setJavaEnabled(true);
  khtml_->setMetaRefreshEnabled(true);
  khtml_->setOnlyLocalReferences(false);
  khtml_->setPluginsEnabled(true);

  // Connect signals for browsing
  connect( khtml_->browserExtension(), SIGNAL(     openURLRequest(const KURL&, const KParts::URLArgs&) ) ,
           this,                         SLOT( slotOpenURLRequest(const KURL&, const KParts::URLArgs&) ) );
}


WebSidebar::~WebSidebar()
{
  
}



// Initialize the sidebar
bool WebSidebar::initialize()
{
  requestGameList();
  return true;
}



// Request the list of games from the msn server
void WebSidebar::requestGameList()
{
  if(appdirService_ == 0)
  {
    appdirService_ = new MsnAppDirectoryService();
    connect(appdirService_, SIGNAL(     requestFinished() ) ,
            this,             SLOT( slotRequestFinished() ) );
  }

  // TODO: handle some caching/singleton stuff somewhere so we only have to request this once
  appdirService_->queryServiceList( MsnAppDirectoryService::GAMES );
}



// Open a new url in the khtml widget
void WebSidebar::slotOpenURLRequest(const KURL &url, const KParts::URLArgs & /* args */)
{
  khtml_->openURL(url);
}



// A request to the msn appdir finished
void WebSidebar::slotRequestFinished()
{
  kdDebug() << "WebSidebar::slotRequestFinished" << endl;
  if(KMESS_NULL(appdirService_)) return;

  khtml_->begin();

  khtml_->write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">"
                "<html><head><meta http-equiv='Content-Type' content='text/html; charset=utf-8' /><title>MSN Activities</title>"
                "<style type='text/css'>"
                "  body   { margin: 0; padding: 5px; font-size: 10pt; }     "
                "  dl     { margin: 0; padding: 0;   }                      "
                "  dt     { font-weight: bold; padding: 1px; clear: left; } "
                "  dt img { float: left; }                                  "
                "  dd     { margin: 0 5px 10px 0; padding: 0; } "
                "</style></head><body><h1>Games</h1><dl>");


  QPtrListIterator<MsnAppDirectoryService::Entry> it( appdirService_->getEntries() );
  while(! it.atLast())
  {
    MsnAppDirectoryService::Entry *entry = it.current();

    khtml_->write("<dt><img src='" + entry->appIconUrl + "' width='22' height='22'><a href='" + entry->url + "'>" + entry->name + "</a></dt>");
    khtml_->write("<dd>" + entry->description + "</dd>");
    ++it;

    kdDebug() << entry->appIconUrl << endl;
    kdDebug() << entry->url << endl;
  }

  khtml_->write("</dl></body></html>");
  khtml_->end();
}


#include "websidebar.moc"
