/***************************************************************************
                          balloon.cpp  -  Nice Balloon
                             -------------------
    begin                : vie mar 29 2002
    copyright            : (C) 2002 by Duncan Mac-Vicar Prett
                           (C) 2001 by Malte Starostik <malte@kde.org>
    email                : duncan@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <qcolor.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qtimer.h>
#include <qtooltip.h>
#include <qpointarray.h>

#include <kapplication.h>
#include <kdebug.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kurllabel.h>

#include "balloon.h"

// The constructor
Balloon::Balloon()
 : BalloonBase(0, 0, WStyle_StaysOnTop | WStyle_Customize | WStyle_NoBorder | WStyle_Tool | WX11BypassWM)
{
  QColor color;
  color.setNamedColor("#000000");
  messageLabel_->setHighlightedColor( color );

  setAutoMask(true);
  installEventFilter(this);
  if ( imageLabel_ ) imageLabel_->installEventFilter(this);
  messageLabel_->installEventFilter(this);

  connect( messageLabel_, SIGNAL( leftClickedURL() ),
           this,          SLOT  (   labelClicked() ) );
}



// The destructor
Balloon::~Balloon()
{
}



void Balloon::callEnded()
{
	/*
	m_image->movie()->restart();
	m_image->movie()->pause();
	if (m_displayName.isEmpty()) m_caption->setText(i18n("Someone was calling you!"));
	else m_caption->setText(i18n("%1 was calling you!").arg(m_displayName));
	m_reject->setEnabled(false);
	*/
}



void Balloon::closeClicked()
{
  emit signalCloseClicked();
}



bool Balloon::eventFilter(QObject *, QEvent *e)
{

	if (e->type() == QEvent::MouseButtonPress && closeButton_->hasMouse() )
	{
		emit closeClicked();
	}
	return false;

}



QString Balloon::getText() const
{
  return messageLabel_->text();
}



void Balloon::labelClicked()
{
  emit signalLabelClicked();
}



void Balloon::setAnchor(const QPoint& anchor)
{
	m_anchor = anchor;
	updateMask();
}



void Balloon::setColor(const QString& colorName)
{
  QColor color;
  color.setNamedColor( colorName );

  // Background of the whole balloon.
  setPaletteBackgroundColor(color);

  // Background of the writing.
  messageLabel_->setPaletteBackgroundColor(color);

  // Set the background and foregound of the close icon.
  closeButton_->setPaletteBackgroundColor(color);
  closeButton_->setPaletteForegroundColor( color.dark() );
}



void Balloon::setPixmap(const QPixmap &pixmap)
{
  if ( imageLabel_ ) imageLabel_->setPixmap( pixmap );
}



void Balloon::setText(const QString& text)
{
  messageLabel_->setText(text);
}



void Balloon::show()
{
  QWidget::show();
  updateMask();
}



void Balloon::updateMask()
{
  QRegion mask(10, 10, width() - 20, height() - 20);

  // REMEMBER: Qt coords are from top left!
  QPoint corners[8] = {
    // these look like the inside coordinates of the arcs
    // top right corner
    QPoint(width() - 50, 8),
    // top left corner
    QPoint(10, 8),
    // bottom left corner
    QPoint(10, height() - 50),
    // bottom right corner
    QPoint(width() - 50, height() - 50),
    // these look like the coordinates of the mask bounding area
    // I'm sure there's an easier way of getting these!
    QPoint(width() - 10, 8),
    QPoint(10, 8),
    QPoint(10, height() - 10),
    QPoint(width() - 10, height() - 10)
  };

  for (int i = 0; i < 4; ++i)
  {
    QPointArray corner;
    corner.makeArc(corners[i].x(), corners[i].y(), 40, 40, i * 16 * 90, 16 * 90);
    // add one more point to the set
    corner.resize(corner.size() + 1);
    // doing this makes the general shape to a rectangle minus a quarter circle
    corner.setPoint(corner.size() - 1, corners[i + 4]);
    mask -= corner;
  }

  // Added/Updated by Scott Morgan - 2002-10-16
  int screen = kapp->desktop()->screenNumber( m_anchor );
  QRect screenSize = kapp->desktop()->screenGeometry(screen);

  bool bottom = (m_anchor.y() + height()) > (screenSize.height() - 48);
  bool right  = (m_anchor.x() + width())  > (screenSize.width() - 48);
  // End of changes

  QPointArray arrow(4);
  arrow.setPoint(0, QPoint(right ? width() : 0, bottom ? height() : 0));
  arrow.setPoint(1, QPoint(right ? width() - 10 : 10, bottom ? height() - 30 : 30));
  arrow.setPoint(2, QPoint(right ? width() - 30 : 30, bottom ? height() - 10 : 10));
  arrow.setPoint(3, arrow[0]);
  mask += arrow;
  setMask(mask);

  move(right ? m_anchor.x() - width() : m_anchor.x(),
       bottom ? m_anchor.y() - height() : m_anchor.y());
}

#include "balloon.moc"
