/***************************************************************************
                          emoticonbutton.h  -  description
                             -------------------
    begin                : Mon May 6 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EMOTICONBUTTON_H
#define EMOTICONBUTTON_H

#include <qwidget.h>
#include <qtoolbutton.h>

// forward declarations
class Emoticon;

/**A button displaying an emoticon for easy insertion into a message.
    Also stores emoticon data for parsing.
  *@author Mike K. Bennett
  */

class EmoticonButton : public QToolButton
{
   Q_OBJECT

  public:
  	                 EmoticonButton(const Emoticon *emoticon, QWidget *parent, const char *name=0);
  	                ~EmoticonButton();

  private slots: // Private slots
    // The button was clicked.
    void             slotClicked();

  private: // Private attributes
    // The emoticon represented by this button.
    const Emoticon  *emoticon_;

  signals: // Signals
    // Request that the emoticon's html code be inserted in the message.
    void             insertEmoticon(QString html);
};

#endif
