/***************************************************************************
                          balloonwidget.h  -  description
                             -------------------
    begin                : Mon May 19 2003
    copyright            : (C) 2003 by Michael Curtis
    email                : michael@kmess.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BALLOONWIDGET_H
#define BALLOONWIDGET_H

#include <qptrlist.h>
#include <qwidget.h>

#include "curvedwidget.h"

/**
  *@author Michael Curtis
  */

class QVBoxLayout;
class NotificationWidget;

class BalloonWidget : public CurvedWidget
{
  Q_OBJECT

  public:
    BalloonWidget(QWidget *parent=0, const char *name=0);
   ~BalloonWidget();

    QPoint       getAnchor() const;
    bool         event( QEvent *event );
    void         setAnchorWidget( QWidget *anchorWidget );

  protected:
    void         updateMask();

  private slots:
    void         empty( NotificationWidget *emptyOne );
    void         full( NotificationWidget *fullOne );

  private:
    // place where the arrow points to
    QWidget                    * anchorWidget_;
    // list of the notificationwidgets that are descended from us
    QPtrList<NotificationWidget> notificationWidgets_;
    // a layout to keep notification widgets in
    QVBoxLayout                 *verticalBox_;
};

#endif
