/***************************************************************************
                          CurvedWidget.h  -  description
                             -------------------
    begin                : Mon May 12 2003
    copyright            : (C) 2003 by Michael Curtis
    email                : michael@kmess.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CURVEDWIDGET_H
#define CURVEDWIDGET_H

#include <qwidget.h>

class QColor;
class QGridLayout;
class QRegion;

class CurvedWidget : public QWidget
{
  Q_OBJECT

  public:
    CurvedWidget( QWidget *parent, const char *name = 0, WFlags f = 0 );
    ~CurvedWidget();

    // get how big our arcs are going to be
    int          getFilletRadius();
    // get how much the mask is indented from the edge of the widget
    int          getIndent();
    // get the "root layout", which is just a grid layout for whatever you might need it for
    QGridLayout *getRootLayout();
    // set how big our arcs are going to be
    void         setFilletRadius( int filletRadius );
    // set how much the mask is indented from the edge of the widget
    //  this is primarily useful if you want to add, say, a callout to one corner
    void         setIndent( int maskIndent );

   protected:
    // draws arcs (fillets) for each corner, and makes them transparent
    void updateMask();

   protected:
    QRegion     *ourMask_;

   private:
    int          filletRadius_;
    int          maskIndent_;
    QGridLayout *layout_;
};

#endif
