#ifndef SERIAL_H
#define SERIAL_H

#include <termios.h>
#include <glib.h>
#include <stdio.h>
#include "config.h"
#define uchar unsigned char

#ifdef  SERIAL_PORT
#define PORTNAME SERIAL_PORT
#endif

#ifdef  SERIAL_SPEED
#define PORTSPEED SERIAL_SPEED
#endif


#ifdef  LINUX

#ifndef  SERIAL_PORT
#define PORTNAME "/dev/ttyS0"
#endif

#ifndef  SERIAL_SPEED
#define PORTSPEED B19200
#endif

#endif

#ifdef  SUNOS

#ifndef  SERIAL_PORT
#define PORTNAME "/dev/ttya"
#endif

#ifndef  SERIAL_SPEED
#define PORTSPEED B115200
#endif

#endif

#ifndef  SUNOS
#ifndef  LINUX


#ifndef  SERIAL_PORT
#define PORTNAME "/dev/ttyS0"
#endif

#ifndef  SERIAL_SPEED
#define PORTSPEED B115200
#endif


#endif
#endif

int serial_FD;
int read_pipe;
int write_pipe;
struct termios serial_originalportsettings;
char* portname;
FILE* comms_file;

int  board_getchararray (int, unsigned char*);
int  board_sendchararray(int, unsigned char*);
int  board_getchar           (unsigned char*);
int  board_sendchar          (unsigned char);
int  board_getb16(int*);
int  board_sendb16(int);
int  board_getb32(int*);
int  board_sendb32(int);
int  serial_setup(int);
void  serial_crash(void);
void  serial_error(char *errorstring);

#endif 
