/***************************************************************************
                                 qssurface.h
                             -------------------
    begin                : 01-January-2000

    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@poczta.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __QSSURFACE_H
#define __QSSURFACE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include"qsplot.h"
#include"qsaxes.h"



/**
  * \brief Dataset: Draws 3d carpet plots
  *
  * Data format is described in QSSurface::Channels . See also QSAxes::plotAdd() .
  */
class QSSurface : public QSPlot3D
   {
    Q_OBJECT
	Q_PROPERTY( int xGridStep READ xGridStep WRITE setXGridStep )
	Q_PROPERTY( int yGridStep READ yGridStep WRITE setYGridStep )
	
    public:
        /**
          * Descriptive names of data channels. See QSData::setMatrix().
	   * XVector ( optional ) contains x coordinates of a grid, YVector ( optional ) contains y coordinates of a grid.
	  * cols(XVector) == cols(ZData) and rows(YVector) == rows(ZData), both vectors must be monotone.
          */
       	enum Channels   {
			  XVector=0,
       	                  YVector=1,
			  ZData = 2,
			  VData  =3 };
       	/**
         * Constructor.
	 */
	QSSurface(QSAxes* parent, const char * name=0);
	/**
          * Destructor.
	  */
	virtual ~QSSurface();
	void setXGridStep( int step );
	void setYGridStep( int step );
	int xGridStep() const { return m_x_grid_step; }
	int yGridStep() const { return m_y_grid_step; }
	virtual QString posInfo( QSPt2f& pos );
	virtual QSPt2f legendItemSize( QSDrv *drv );
	virtual void drawLegendItem( const QSPt2f& pos, QSDrv *drv );
	virtual void loadStateFromStream( QDataStream& stream, QSObjectFactory *factory );
	virtual void saveStateToStream( QDataStream& stream, QSObjectFactory *factory );
        virtual ColumnType columnType( int channel, int column ) const;
	virtual QString channelVariable( int channel ) const;

   protected:
      virtual void dataChanged( int channel = -1 );
      virtual void allocRuntimeData();
      virtual void freeRuntimeData();
      virtual bool getAxisRange( QSAxis *axis, double& min, double& max );
      virtual bool start();
      virtual bool step();
      virtual void end();

    private:
	struct surface_runtime_data;
	struct surface_runtime_data *d;
        bool   m_minmax_z_valid;
	bool   m_minmax_v_valid;
        double m_max_z;
        double m_min_z;
	double m_min_v;
	double m_max_v;
	int m_x_grid_step;
	int m_y_grid_step;

        void init_loops();	
	void prepare_quarter();
	void draw_polygon( const QSPt3f pts[], QSPt3f *norm, const double *values=NULL, const bool *edges=NULL );
   };

#endif


















































